/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import java.lang.reflect.Type;
import org.joda.time.LocalDate;

public final class LocalDateSerializer
extends JodaDateSerializerBase<LocalDate> {
    protected static final JacksonJodaFormat DEFAULT_FORMAT = new JacksonJodaFormat(DEFAULT_DATEONLY_FORMAT);

    public LocalDateSerializer() {
        this(DEFAULT_FORMAT);
    }

    public LocalDateSerializer(JacksonJodaFormat format2) {
        super(LocalDate.class, format2);
    }

    public LocalDateSerializer withFormat(JacksonJodaFormat formatter) {
        return this._format == formatter ? this : new LocalDateSerializer(formatter);
    }

    @Override
    public void serialize(LocalDate value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._useTimestamp(provider)) {
            jgen.writeStartArray();
            jgen.writeNumber(value2.year().get());
            jgen.writeNumber(value2.monthOfYear().get());
            jgen.writeNumber(value2.dayOfMonth().get());
            jgen.writeEndArray();
        } else {
            jgen.writeString(this._format.createFormatter(provider).print(value2));
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._useTimestamp(provider) ? "array" : "string", true);
    }
}

