/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.Range;
import java.io.IOException;

public class RangeSerializer
extends StdSerializer<Range<?>>
implements ContextualSerializer {
    protected final JavaType _rangeType;
    protected final JsonSerializer<Object> _endpointSerializer;

    public RangeSerializer(JavaType type) {
        this(type, null);
    }

    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer) {
        super(type);
        this._rangeType = type;
        this._endpointSerializer = endpointSer;
    }

    @Override
    public boolean isEmpty(Range<?> value2) {
        return super.isEmpty(value2);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JavaType endpointType;
        if (this._endpointSerializer == null && (endpointType = this._rangeType.containedType(0)) != null && !endpointType.hasRawClass(Object.class)) {
            JsonSerializer<Object> ser = prov.findValueSerializer(endpointType, property);
            return new RangeSerializer(this._rangeType, ser);
        }
        return this;
    }

    @Override
    public void serialize(Range<?> value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        this._writeContents(value2, jgen, provider);
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(Range<?> value2, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        typeSer.writeTypePrefixForObject(value2, jgen);
        this._writeContents(value2, jgen, provider);
        typeSer.writeTypeSuffixForObject(value2, jgen);
    }

    private void _writeContents(Range<?> value2, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value2.hasLowerBound()) {
            if (this._endpointSerializer != null) {
                jgen.writeFieldName("lowerEndpoint");
                this._endpointSerializer.serialize(value2.lowerEndpoint(), jgen, provider);
            } else {
                provider.defaultSerializeField("lowerEndpoint", value2.lowerEndpoint(), jgen);
            }
            provider.defaultSerializeField("lowerBoundType", (Object)value2.lowerBoundType(), jgen);
        }
        if (value2.hasUpperBound()) {
            if (this._endpointSerializer != null) {
                jgen.writeFieldName("upperEndpoint");
                this._endpointSerializer.serialize(value2.upperEndpoint(), jgen, provider);
            } else {
                provider.defaultSerializeField("upperEndpoint", value2.upperEndpoint(), jgen);
            }
            provider.defaultSerializeField("upperBoundType", (Object)value2.upperBoundType(), jgen);
        }
    }
}

