/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Optional;
import java.io.IOException;

public final class GuavaOptionalSerializer
extends StdSerializer<Optional<?>> {
    public GuavaOptionalSerializer(JavaType type) {
        super(type);
    }

    @Override
    public boolean isEmpty(Optional<?> value2) {
        return value2 == null || !value2.isPresent();
    }

    @Override
    public void serialize(Optional<?> value2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (value2.isPresent()) {
            provider.defaultSerializeValue(value2.get(), jgen);
        } else {
            provider.defaultSerializeNull(jgen);
        }
    }

    @Override
    public void serializeWithType(Optional<?> value2, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(value2, jgen, provider);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JavaType typeParameter = typeHint.containedType(0);
        if (typeParameter != null) {
            visitor.getProvider().findValueSerializer(typeParameter, null).acceptJsonFormatVisitor(visitor, typeParameter);
            return;
        }
        super.acceptJsonFormatVisitor(visitor, typeHint);
    }
}

