/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.net.HostAndPort;
import java.io.IOException;

public class HostAndPortDeserializer
extends StdDeserializer<HostAndPort> {
    private static final long serialVersionUID = 1L;
    public static final HostAndPortDeserializer std = new HostAndPortDeserializer();

    public HostAndPortDeserializer() {
        super(HostAndPort.class);
    }

    @Override
    public HostAndPort deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            JsonNode root2 = (JsonNode)jp.readValueAsTree();
            String host = root2.path("hostText").asText();
            JsonNode n = root2.get("port");
            if (n == null) {
                return HostAndPort.fromString(host);
            }
            return HostAndPort.fromParts(host, n.asInt());
        }
        if (t == JsonToken.VALUE_STRING) {
            return HostAndPort.fromString(jp.getText().trim());
        }
        throw ctxt.wrongTokenException(jp, JsonToken.VALUE_STRING, "(or JSON Object)");
    }
}

