/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ThreadDeadlockDetector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ThreadStatesGaugeSet
implements MetricSet {
    private final ThreadMXBean threads;
    private final ThreadDeadlockDetector deadlockDetector;

    public ThreadStatesGaugeSet() {
        this(ManagementFactory.getThreadMXBean(), new ThreadDeadlockDetector());
    }

    public ThreadStatesGaugeSet(ThreadMXBean threads, ThreadDeadlockDetector deadlockDetector) {
        this.threads = threads;
        this.deadlockDetector = deadlockDetector;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge<Object>> gauges = new HashMap<String, Gauge<Object>>();
        for (final Thread.State state : Thread.State.values()) {
            gauges.put(MetricRegistry.name(state.toString().toLowerCase(), "count"), new Gauge<Object>(){

                @Override
                public Object getValue() {
                    return ThreadStatesGaugeSet.this.getThreadCount(state);
                }
            });
        }
        gauges.put("count", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return ThreadStatesGaugeSet.this.threads.getThreadCount();
            }
        });
        gauges.put("daemon.count", new Gauge<Integer>(){

            @Override
            public Integer getValue() {
                return ThreadStatesGaugeSet.this.threads.getDaemonThreadCount();
            }
        });
        gauges.put("deadlocks", new Gauge<Set<String>>(){

            @Override
            public Set<String> getValue() {
                return ThreadStatesGaugeSet.this.deadlockDetector.getDeadlockedThreads();
            }
        });
        return Collections.unmodifiableMap(gauges);
    }

    private int getThreadCount(Thread.State state) {
        ThreadInfo[] allThreads = this.threads.getThreadInfo(this.threads.getAllThreadIds());
        int count2 = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null || info.getThreadState() != state) continue;
            ++count2;
        }
        return count2;
    }
}

