/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.internal.Lists;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameterized {
    private Field m_field;
    private Method m_method;
    private Method m_getter;
    private WrappedParameter m_wrappedParameter;
    private ParametersDelegate m_parametersDelegate;

    public Parameterized(WrappedParameter wp, ParametersDelegate pd, Field field2, Method method) {
        this.m_wrappedParameter = wp;
        this.m_method = method;
        this.m_field = field2;
        if (this.m_field != null) {
            this.m_field.setAccessible(true);
        }
        this.m_parametersDelegate = pd;
    }

    public static List<Parameterized> parseArg(Object arg) {
        DynamicParameter dynamicParameter;
        ParametersDelegate delegateAnnotation;
        Parameter annotation;
        List<Parameterized> result2 = Lists.newArrayList();
        Class<?> cls = arg.getClass();
        while (!Object.class.equals(cls)) {
            for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
                annotation = ((Field)accessibleObject).getAnnotation(Parameter.class);
                delegateAnnotation = ((Field)accessibleObject).getAnnotation(ParametersDelegate.class);
                dynamicParameter = ((Field)accessibleObject).getAnnotation(DynamicParameter.class);
                if (annotation != null) {
                    result2.add(new Parameterized(new WrappedParameter(annotation), null, (Field)accessibleObject, null));
                    continue;
                }
                if (dynamicParameter != null) {
                    result2.add(new Parameterized(new WrappedParameter(dynamicParameter), null, (Field)accessibleObject, null));
                    continue;
                }
                if (delegateAnnotation == null) continue;
                result2.add(new Parameterized(null, delegateAnnotation, (Field)accessibleObject, null));
            }
            cls = cls.getSuperclass();
        }
        cls = arg.getClass();
        while (!Object.class.equals(cls)) {
            for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
                annotation = ((Method)accessibleObject).getAnnotation(Parameter.class);
                delegateAnnotation = ((Method)accessibleObject).getAnnotation(ParametersDelegate.class);
                dynamicParameter = ((Method)accessibleObject).getAnnotation(DynamicParameter.class);
                if (annotation != null) {
                    result2.add(new Parameterized(new WrappedParameter(annotation), null, null, (Method)accessibleObject));
                    continue;
                }
                if (dynamicParameter != null) {
                    result2.add(new Parameterized(new WrappedParameter((DynamicParameter)((Object)annotation)), null, null, (Method)accessibleObject));
                    continue;
                }
                if (delegateAnnotation == null) continue;
                result2.add(new Parameterized(null, delegateAnnotation, null, (Method)accessibleObject));
            }
            cls = cls.getSuperclass();
        }
        return result2;
    }

    public WrappedParameter getWrappedParameter() {
        return this.m_wrappedParameter;
    }

    public Class<?> getType() {
        if (this.m_method != null) {
            return this.m_method.getParameterTypes()[0];
        }
        return this.m_field.getType();
    }

    public String getName() {
        if (this.m_method != null) {
            return this.m_method.getName();
        }
        return this.m_field.getName();
    }

    public Object get(Object object) {
        try {
            if (this.m_method != null) {
                if (this.m_getter == null) {
                    this.m_getter = this.m_method.getDeclaringClass().getMethod("g" + this.m_method.getName().substring(1), new Class[0]);
                }
                return this.m_getter.invoke(object, new Object[0]);
            }
            return this.m_field.get(object);
        }
        catch (SecurityException e) {
            throw new ParameterException(e);
        }
        catch (NoSuchMethodException e) {
            String name = this.m_method.getName();
            String fieldName = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            Object result2 = null;
            try {
                Field field2 = this.m_method.getDeclaringClass().getDeclaredField(fieldName);
                if (field2 != null) {
                    field2.setAccessible(true);
                    result2 = field2.get(object);
                }
            }
            catch (NoSuchFieldException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
            return result2;
        }
        catch (IllegalArgumentException e) {
            throw new ParameterException(e);
        }
        catch (IllegalAccessException e) {
            throw new ParameterException(e);
        }
        catch (InvocationTargetException e) {
            throw new ParameterException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.m_field == null ? 0 : this.m_field.hashCode());
        result2 = 31 * result2 + (this.m_method == null ? 0 : this.m_method.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameterized other = (Parameterized)obj;
        if (this.m_field == null ? other.m_field != null : !this.m_field.equals(other.m_field)) {
            return false;
        }
        return !(this.m_method == null ? other.m_method != null : !this.m_method.equals(other.m_method));
    }

    public boolean isDynamicParameter(Field field2) {
        if (this.m_method != null) {
            return this.m_method.getAnnotation(DynamicParameter.class) != null;
        }
        return this.m_field.getAnnotation(DynamicParameter.class) != null;
    }

    public void set(Object object, Object value2) {
        try {
            if (this.m_method != null) {
                this.m_method.invoke(object, value2);
            } else {
                this.m_field.set(object, value2);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ParameterException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ParameterException(ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof ParameterException) {
                throw (ParameterException)ex.getTargetException();
            }
            throw new ParameterException(ex);
        }
    }

    public ParametersDelegate getDelegateAnnotation() {
        return this.m_parametersDelegate;
    }

    public Type getGenericType() {
        if (this.m_method != null) {
            return this.m_method.getGenericParameterTypes()[0];
        }
        return this.m_field.getGenericType();
    }

    public Parameter getParameter() {
        return this.m_wrappedParameter.getParameter();
    }

    public Type findFieldGenericType() {
        ParameterizedType p;
        Type cls;
        if (this.m_method != null) {
            return null;
        }
        if (this.m_field.getGenericType() instanceof ParameterizedType && (cls = (p = (ParameterizedType)this.m_field.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
            return cls;
        }
        return null;
    }

    public boolean isDynamicParameter() {
        return this.m_wrappedParameter.getDynamicParameter() != null;
    }
}

