/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.server;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.telemetry.TelemetryNodeService;
import org.graylog2.telemetry.dto.ClusterDataSet;
import org.graylog2.telemetry.dto.NodeDataSet;
import org.graylog2.telemetry.server.TelemetryClusterService;

@RequiresAuthentication
@Api(value="Telemetry", description="Telemetry data about this Graylog setup")
@Path(value="/")
public class TelemetryServerResource
extends RestResource
implements PluginRestResource {
    private final TelemetryNodeService telemetryNodeService;
    private final TelemetryClusterService telemetryClusterService;

    @Inject
    public TelemetryServerResource(TelemetryNodeService telemetryNodeService, TelemetryClusterService telemetryClusterService) {
        this.telemetryNodeService = telemetryNodeService;
        this.telemetryClusterService = telemetryClusterService;
    }

    @GET
    @Path(value="node")
    @Timed
    @ApiOperation(value="Return the telemetry data of this Graylog node")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=500, message="Internal Server Error")})
    public NodeDataSet telemetryNodeDataSet() {
        return this.telemetryNodeService.buildNodeDataSet();
    }

    @GET
    @Path(value="cluster")
    @Timed
    @ApiOperation(value="Return the telemetry data of this Graylog cluster")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=500, message="Internal Server Error")})
    public ClusterDataSet telemetryClusterDataSet() {
        return this.telemetryClusterService.buildClusterDataSet();
    }
}

