/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.server;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.indexer.counts.Counts;
import org.graylog2.shared.stats.ThroughputStats;
import org.graylog2.system.stats.ClusterStatsService;
import org.graylog2.telemetry.TelemetryMetaData;
import org.graylog2.telemetry.dto.ClusterDataSet;

@Singleton
public class TelemetryClusterService {
    private final ClusterStatsService clusterStatsService;
    private final Counts counts;
    private final ThroughputStats throughputStats;
    private final Supplier<ClusterDataSet> cachedDataSet;
    private final long reportIntervalMs;

    @Inject
    public TelemetryClusterService(ClusterStatsService clusterStatsService, @Nullable Counts counts, ThroughputStats throughputStats, @Named(value="telemetry_cache_timeout") Duration cacheTimeout, @Named(value="telemetry_report_interval") Duration reportInterval) {
        this.clusterStatsService = clusterStatsService;
        this.counts = counts;
        this.throughputStats = throughputStats;
        this.cachedDataSet = Suppliers.memoizeWithExpiration(this.cachingSupplier(), (long)cacheTimeout.getQuantity(), (TimeUnit)cacheTimeout.getUnit());
        this.reportIntervalMs = reportInterval.toMilliseconds();
    }

    public ClusterDataSet buildClusterDataSet() {
        return (ClusterDataSet)this.cachedDataSet.get();
    }

    private Supplier<ClusterDataSet> cachingSupplier() {
        return new Supplier<ClusterDataSet>(){

            public ClusterDataSet get() {
                return ClusterDataSet.create(String.valueOf(TelemetryMetaData.VERSION), System.currentTimeMillis(), TelemetryClusterService.this.reportIntervalMs, TelemetryClusterService.this.counts == null ? 0L : TelemetryClusterService.this.counts.total(), TelemetryClusterService.this.throughputStats.getCurrentThroughput(), TelemetryClusterService.this.throughputStats.getCurrentStreamThroughputValues(), TelemetryClusterService.this.clusterStatsService.clusterStats());
            }
        };
    }
}

