/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.EvictingQueue;
import com.squareup.okhttp.OkHttpClient;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.telemetry.TelemetryConfiguration;
import org.graylog2.telemetry.TelemetryPeriodical;
import org.graylog2.telemetry.TelemetryRequest;
import org.graylog2.telemetry.server.TelemetryClusterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TelemetryClusterPeriodical
extends TelemetryPeriodical {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryClusterPeriodical.class);
    private final ServerStatus serverStatus;
    private final TelemetryClusterService telemetryClusterService;

    @Inject
    public TelemetryClusterPeriodical(TelemetryClusterService telemetryClusterService, ServerStatus serverStatus, TelemetryConfiguration config, @Named(value="telemetryHttpClient") OkHttpClient httpClient, @Named(value="telemetryObjectMapper") ObjectMapper objectMapper) {
        this(telemetryClusterService, serverStatus, config, (EvictingQueue<TelemetryRequest>)EvictingQueue.create((int)config.getMaxQueueSize()), httpClient, objectMapper);
    }

    private TelemetryClusterPeriodical(TelemetryClusterService telemetryClusterService, ServerStatus serverStatus, TelemetryConfiguration telemetryConfiguration, EvictingQueue<TelemetryRequest> evictingQueue, OkHttpClient httpClient, ObjectMapper objectMapper) {
        super(telemetryConfiguration, evictingQueue, httpClient, objectMapper, TelemetryClusterPeriodical.buildTelemetryUrl(telemetryConfiguration.getUrl()), "cluster-%s.smile");
        this.serverStatus = serverStatus;
        this.telemetryClusterService = telemetryClusterService;
    }

    private static URL buildTelemetryUrl(URI uri) {
        try {
            return uri.resolve("cluster").toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    protected byte[] buildPayload() {
        try {
            return this.objectMapper.writeValueAsBytes((Object)this.telemetryClusterService.buildClusterDataSet());
        }
        catch (JsonProcessingException e) {
            LOG.error("Error while serializing telemetry data", (Throwable)e);
            return null;
        }
    }

    public boolean startOnThisNode() {
        return this.config.isEnabled() && this.telemetryUrl != null && this.serverStatus.hasCapability(ServerStatus.Capability.MASTER) && !this.serverStatus.hasCapability(ServerStatus.Capability.LOCALMODE);
    }

    protected Logger getLogger() {
        return LOG;
    }
}

