/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.radio;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.telemetry.TelemetryNodeService;
import org.graylog2.telemetry.dto.NodeDataSet;

@RequiresAuthentication
@Api(value="Telemetry", description="Telemetry data about this Graylog Radio node")
@Path(value="/")
public class TelemetryRadioResource
extends RestResource
implements PluginRestResource {
    private final TelemetryNodeService telemetryNodeService;

    @Inject
    public TelemetryRadioResource(TelemetryNodeService telemetryNodeService) {
        this.telemetryNodeService = telemetryNodeService;
    }

    @GET
    @Path(value="node")
    @Timed
    @ApiOperation(value="Return the telemetry data of this Graylog node")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=500, message="Internal Server Error")})
    public NodeDataSet telemetryNodeDataSet() {
        return this.telemetryNodeService.buildNodeDataSet();
    }
}

