/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.providers;

import com.github.joschi.jadconfig.util.Duration;
import com.squareup.okhttp.OkHttpClient;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.graylog2.telemetry.okhttp.GzipRequestInterceptor;

public class OkHttpClientProvider
implements Provider<OkHttpClient> {
    private final OkHttpClient client = new OkHttpClient();

    @Inject
    public OkHttpClientProvider(@Named(value="telemetry_service_connect_timeout") Duration connectTimeout, @Named(value="telemetry_service_read_timeout") Duration readTimeout, @Named(value="telemetry_service_write_timeout") Duration writeTimeout, @Named(value="telemetry_gzip_enabled") boolean gzipEnabled, @Named(value="http_proxy_uri") @Nullable URI httpProxyUri) {
        this.client.setRetryOnConnectionFailure(true);
        this.client.setConnectTimeout(connectTimeout.getQuantity(), connectTimeout.getUnit());
        this.client.setWriteTimeout(writeTimeout.getQuantity(), writeTimeout.getUnit());
        this.client.setReadTimeout(readTimeout.getQuantity(), readTimeout.getUnit());
        if (gzipEnabled) {
            this.client.interceptors().add(new GzipRequestInterceptor());
        }
        if (httpProxyUri != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyUri.getHost(), httpProxyUri.getPort()));
            this.client.setProxy(proxy);
        }
    }

    public OkHttpClient get() {
        return this.client;
    }
}

