/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.dto;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.graylog2.shared.system.stats.SystemStats;
import org.graylog2.telemetry.dto.AutoValue_NodeDataSet;
import org.graylog2.telemetry.dto.NodeInfo;
import org.graylog2.telemetry.dto.NodeStats;
import org.hibernate.validator.constraints.NotEmpty;

@JsonAutoDetect
public abstract class NodeDataSet {
    @JsonProperty
    public abstract String version();

    @JsonProperty
    public abstract long timestamp();

    @JsonProperty
    public abstract long reportIntervalMs();

    @JsonProperty
    public abstract NodeInfo nodeInfo();

    @JsonProperty
    public abstract NodeStats nodeStats();

    @JsonProperty
    public abstract MetricRegistry metrics();

    @JsonProperty
    public abstract SystemStats systemStats();

    public static NodeDataSet create(@NotEmpty String version, @Min(value=0L) long timestamp, @Min(value=0L) long reportIntervalMs, @Valid NodeInfo nodeInfo, @Valid NodeStats nodeStats, @Valid MetricRegistry metrics, @Valid SystemStats systemStats) {
        return new AutoValue_NodeDataSet(version, timestamp, reportIntervalMs, nodeInfo, nodeStats, metrics, systemStats);
    }
}

