/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.graylog2.system.stats.ClusterStats;
import org.graylog2.telemetry.dto.AutoValue_ClusterDataSet;
import org.hibernate.validator.constraints.NotEmpty;

@JsonAutoDetect
public abstract class ClusterDataSet {
    @JsonProperty
    public abstract String version();

    @JsonProperty
    public abstract long timestamp();

    @JsonProperty
    public abstract long reportIntervalMs();

    @JsonProperty
    public abstract long totalMessages();

    @JsonProperty
    public abstract long globalThroughput();

    @JsonProperty
    public abstract Map<String, Long> streamThroughput();

    @JsonProperty
    public abstract ClusterStats clusterStats();

    public static ClusterDataSet create(@NotEmpty String version, @Min(value=0L) long timestamp, @Min(value=0L) long reportIntervalMs, @Min(value=0L) long totalMessages, @Min(value=0L) long globalThroughput, @NotNull Map<String, Long> streamThroughput, @Valid ClusterStats clusterStats) {
        return new AutoValue_ClusterDataSet(version, timestamp, reportIntervalMs, totalMessages, globalThroughput, streamThroughput, clusterStats);
    }
}

