/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.telemetry.TelemetryConfiguration;
import org.graylog2.telemetry.TelemetryMetaData;
import org.graylog2.telemetry.TelemetryRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;

public abstract class TelemetryPeriodical
extends Periodical {
    private static final MediaType CONTENT_TYPE = MediaType.parse("application/x-jackson-smile");
    private static final String TELEMETRY_VERSION = TelemetryMetaData.VERSION.toString();
    private static final String USER_AGENT = "Graylog " + Version.CURRENT_CLASSPATH;
    protected final TelemetryConfiguration config;
    protected final EvictingQueue<TelemetryRequest> cachedRequestsQueue;
    protected final ObjectMapper objectMapper;
    protected final OkHttpClient httpClient;
    protected final String credentials;
    protected final URL telemetryUrl;
    protected final String filenamePattern;
    private final Logger log = this.getLogger();

    protected TelemetryPeriodical(TelemetryConfiguration config, EvictingQueue<TelemetryRequest> telemetryRequestsQueue, OkHttpClient httpClient, ObjectMapper objectMapper, URL telemetryUrl, String filenamePattern) {
        this.config = (TelemetryConfiguration)Preconditions.checkNotNull((Object)config);
        this.cachedRequestsQueue = (EvictingQueue)Preconditions.checkNotNull(telemetryRequestsQueue);
        this.httpClient = (OkHttpClient)Preconditions.checkNotNull((Object)httpClient);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.credentials = Credentials.basic("telemetry", config.getToken());
        this.telemetryUrl = (URL)Preconditions.checkNotNull((Object)telemetryUrl);
        this.filenamePattern = (String)Preconditions.checkNotNull((Object)filenamePattern);
    }

    protected abstract byte[] buildPayload();

    public void doRun() {
        this.log.debug("Telemetry is activated: Transmitting node data sets.");
        byte[] requestBody = this.buildPayload();
        if (this.config.isOfflineMode()) {
            boolean success;
            String filename = String.format(this.filenamePattern, DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
            if (!this.config.getDirectory().exists() && !(success = this.config.getDirectory().mkdirs())) {
                this.log.error("Couldn't create directory {}", (Object)this.config.getDirectory().getAbsolutePath());
                return;
            }
            File file = new File(this.config.getDirectory(), filename);
            this.log.debug("Telemetry is in offline mode. Writing data into {}", (Object)file);
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                ((OutputStream)outputStream).write(requestBody);
            }
            catch (IOException e) {
                this.log.warn("Couldn't write telemetry data into " + file, (Throwable)e);
            }
        } else {
            Headers headers = new Headers.Builder().add("Authorization", this.credentials).add("User-Agent", USER_AGENT).add("X-Telemetry-Version", TELEMETRY_VERSION).build();
            TelemetryRequest request = TelemetryRequest.create(headers, requestBody);
            boolean success = this.uploadDataSet(request);
            if (!success) {
                this.cachedRequestsQueue.add((Object)request);
            } else if (!this.cachedRequestsQueue.isEmpty()) {
                this.log.debug("Trying to upload {} queued data sets", (Object)this.cachedRequestsQueue.size());
                this.uploadQueuedDataSets();
            }
        }
    }

    protected void uploadQueuedDataSets() {
        ArrayList unsuccessfulRequests = Lists.newArrayListWithCapacity((int)this.cachedRequestsQueue.size());
        while (!this.cachedRequestsQueue.isEmpty()) {
            TelemetryRequest request = (TelemetryRequest)this.cachedRequestsQueue.poll();
            boolean success = this.uploadDataSet(request);
            if (success) continue;
            this.log.debug("Couldn't successfully upload telemetry data set, re-queueing data");
            unsuccessfulRequests.add(request);
        }
        this.cachedRequestsQueue.addAll((Collection)unsuccessfulRequests);
    }

    protected boolean uploadDataSet(TelemetryRequest telemetryRequest) {
        Response response;
        Request request = new Request.Builder().url(this.telemetryUrl).headers(telemetryRequest.headers()).post(RequestBody.create(CONTENT_TYPE, telemetryRequest.body())).build();
        try {
            response = this.httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            this.log.error("Error while uploading telemetry data");
            this.log.debug("Error details", (Throwable)e);
            return false;
        }
        if (!response.isSuccessful()) {
            this.log.warn("Couldn't successfully upload telemetry data set: {}", (Object)response);
            return false;
        }
        return true;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return false;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return 60;
    }

    public int getPeriodSeconds() {
        return Ints.saturatedCast((long)this.config.getReportInterval().toSeconds());
    }
}

