/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.Version;
import org.graylog2.shared.system.stats.StatsService;
import org.graylog2.telemetry.dto.NodeDataSet;
import org.graylog2.telemetry.dto.NodeInfo;
import org.graylog2.telemetry.dto.NodeRole;
import org.graylog2.telemetry.dto.NodeStats;
import org.graylog2.telemetry.dto.PluginInfo;
import org.graylog2.telemetry.server.TelemetryServerMetaData;

@Singleton
public class TelemetryNodeService {
    private static final Set<String> METRICS_BLACKLIST = ImmutableSet.builder().add((Object)"org.graylog2.rest.resources").build();
    public static final MetricFilter METRICS_FILTER = new MetricFilter(){

        public boolean matches(String name, Metric metric) {
            for (String prefix : METRICS_BLACKLIST) {
                if (!name.startsWith(prefix)) continue;
                return false;
            }
            return true;
        }
    };
    private final ServerStatus serverStatus;
    private final MetricRegistry metricRegistry;
    private final StatsService statsService;
    private final Set<PluginMetaData> plugins;
    private final String nodeId;
    private final NodeInfo nodeInfo;
    private final Supplier<NodeDataSet> cachedDataSet;
    private final long reportIntervalMs;
    @Inject(optional=true)
    private InputService inputService = null;

    @javax.inject.Inject
    public TelemetryNodeService(ServerStatus serverStatus, MetricRegistry metricRegistry, StatsService statsService, Set<PluginMetaData> plugins, @Named(value="telemetry_cache_timeout") Duration cacheTimeout, @Named(value="telemetry_report_interval") Duration reportInterval) {
        this.serverStatus = serverStatus;
        this.metricRegistry = metricRegistry;
        this.statsService = statsService;
        this.plugins = plugins;
        this.nodeId = serverStatus.getNodeId().toString();
        this.nodeInfo = this.buildNodeInfo();
        this.cachedDataSet = Suppliers.memoizeWithExpiration(this.cachingSupplier(), (long)cacheTimeout.getQuantity(), (TimeUnit)cacheTimeout.getUnit());
        this.reportIntervalMs = reportInterval.toMilliseconds();
    }

    private NodeInfo buildNodeInfo() {
        return NodeInfo.create(this.nodeId, this.serverStatus.getNodeId().anonymize(), this.nodeRole(), Tools.getLocalHostname(), Version.CURRENT_CLASSPATH.toString(), this.serverStatus.getStartedAt(), this.serverStatus.getTimezone(), this.buildPluginInfo());
    }

    private Set<PluginInfo> buildPluginInfo() {
        HashSet pluginInfos = Sets.newHashSetWithExpectedSize((int)this.plugins.size());
        for (PluginMetaData pluginMetaData : this.plugins) {
            pluginInfos.add(PluginInfo.create(pluginMetaData.getUniqueId(), pluginMetaData.getName(), pluginMetaData.getVersion().toString()));
        }
        return pluginInfos;
    }

    private NodeRole nodeRole() {
        if (this.serverStatus.hasCapabilities(new ServerStatus.Capability[]{ServerStatus.Capability.MASTER})) {
            return NodeRole.MASTER;
        }
        if (this.serverStatus.hasCapabilities(new ServerStatus.Capability[]{ServerStatus.Capability.SERVER})) {
            return NodeRole.SERVER;
        }
        if (this.serverStatus.hasCapabilities(new ServerStatus.Capability[]{ServerStatus.Capability.RADIO})) {
            return NodeRole.RADIO;
        }
        return null;
    }

    public NodeDataSet buildNodeDataSet() {
        return (NodeDataSet)this.cachedDataSet.get();
    }

    private Supplier<NodeDataSet> cachingSupplier() {
        return new Supplier<NodeDataSet>(){

            public NodeDataSet get() {
                NodeStats nodeStats = NodeStats.create(TelemetryNodeService.this.serverStatus.getLifecycle(), TelemetryNodeService.this.serverStatus.isProcessing(), TelemetryNodeService.this.serverStatus.getLifecycle().getLoadbalancerStatus(), TelemetryNodeService.this.inputService == null ? -1L : TelemetryNodeService.this.inputService.totalCountForNode(TelemetryNodeService.this.nodeId));
                return NodeDataSet.create(String.valueOf(TelemetryServerMetaData.VERSION), System.currentTimeMillis(), TelemetryNodeService.this.reportIntervalMs, TelemetryNodeService.this.nodeInfo, nodeStats, TelemetryNodeService.this.metricRegistry, TelemetryNodeService.this.statsService.systemStats());
            }
        };
    }
}

