/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.EvictingQueue;
import com.squareup.okhttp.OkHttpClient;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.telemetry.TelemetryConfiguration;
import org.graylog2.telemetry.TelemetryNodeService;
import org.graylog2.telemetry.TelemetryPeriodical;
import org.graylog2.telemetry.TelemetryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TelemetryNodePeriodical
extends TelemetryPeriodical {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryNodePeriodical.class);
    private final ServerStatus serverStatus;
    private final TelemetryNodeService telemetryNodeService;

    @Inject
    public TelemetryNodePeriodical(TelemetryNodeService telemetryNodeService, NodeId nodeId, ServerStatus serverStatus, TelemetryConfiguration telemetryConfiguration, @Named(value="telemetryHttpClient") OkHttpClient httpClient, @Named(value="telemetryObjectMapper") ObjectMapper objectMapper) {
        this(telemetryNodeService, nodeId, serverStatus, telemetryConfiguration, (EvictingQueue<TelemetryRequest>)EvictingQueue.create((int)telemetryConfiguration.getMaxQueueSize()), httpClient, objectMapper);
    }

    private TelemetryNodePeriodical(TelemetryNodeService telemetryNodeService, NodeId nodeId, ServerStatus serverStatus, TelemetryConfiguration config, EvictingQueue<TelemetryRequest> evictingQueue, OkHttpClient httpClient, ObjectMapper objectMapper) {
        super(config, evictingQueue, httpClient, objectMapper, TelemetryNodePeriodical.buildTelemetryUrl(config.getUrl(), nodeId), "node-" + nodeId + "-%s.smile");
        this.serverStatus = serverStatus;
        this.telemetryNodeService = telemetryNodeService;
    }

    private static URL buildTelemetryUrl(URI uri, NodeId nodeId) {
        try {
            return uri.resolve("node/" + nodeId).toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    protected byte[] buildPayload() {
        try {
            return this.objectMapper.writeValueAsBytes((Object)this.telemetryNodeService.buildNodeDataSet());
        }
        catch (JsonProcessingException e) {
            LOG.error("Error while serializing telemetry data", (Throwable)e);
            return null;
        }
    }

    public boolean startOnThisNode() {
        return this.config.isEnabled() && this.telemetryUrl != null && !this.serverStatus.hasCapability(ServerStatus.Capability.LOCALMODE);
    }

    protected Logger getLogger() {
        return LOG;
    }
}

