/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import org.graylog2.plugin.PluginConfigBean;

public class TelemetryConfiguration
implements PluginConfigBean {
    private static final String PREFIX = "telemetry_";
    @Parameter(value="telemetry_enabled")
    private boolean enabled = false;
    @Parameter(value="telemetry_token", required=true)
    private String token = "";
    @Parameter(value="telemetry_url", required=true)
    private URI url = URI.create("https://telemetry-in.graylog.com/submit/");
    @Parameter(value="telemetry_service_connect_timeout", validator=PositiveDurationValidator.class)
    private Duration connectTimeout = Duration.seconds((long)1L);
    @Parameter(value="telemetry_service_write_timeout", validator=PositiveDurationValidator.class)
    private Duration writeTimeout = Duration.seconds((long)5L);
    @Parameter(value="telemetry_service_read_timeout", validator=PositiveDurationValidator.class)
    private Duration readTimeout = Duration.seconds((long)5L);
    @Parameter(value="telemetry_cache_timeout", required=true, validator=PositiveDurationValidator.class)
    private Duration cacheTimeout = Duration.minutes((long)1L);
    @Parameter(value="telemetry_max_queue_size", required=true, validator=PositiveIntegerValidator.class)
    private int maxQueueSize = 10;
    @Parameter(value="telemetry_report_interval", required=true, validator=PositiveDurationValidator.class)
    private Duration reportInterval = Duration.minutes((long)1L);
    @Parameter(value="telemetry_gzip_enabled")
    private boolean gzipEnabled = true;
    @Parameter(value="telemetry_offline_mode")
    private boolean offlineMode = false;
    @Parameter(value="telemetry_dir")
    private File directory = new File("data/telemetry");

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getToken() {
        return this.token;
    }

    public URI getUrl() {
        return this.url;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getCacheTimeout() {
        return this.cacheTimeout;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public Duration getReportInterval() {
        return this.reportInterval;
    }

    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public File getDirectory() {
        return this.directory;
    }

    @ValidatorMethod
    public void validate() throws ValidationException {
        if (this.isEnabled() && this.isOfflineMode() && this.getDirectory().exists() && !this.getDirectory().isDirectory()) {
            throw new ValidationException("Directory " + this.getDirectory() + " must be a directory.");
        }
        if (this.isEnabled() && this.isOfflineMode() && this.getDirectory().exists() && !this.getDirectory().canWrite()) {
            throw new ValidationException("Directory " + this.getDirectory() + " must be writable.");
        }
        if (this.isEnabled() && !this.isOfflineMode() && Strings.isNullOrEmpty((String)this.getToken())) {
            throw new ValidationException("Authentication token for telemetry is missing.");
        }
    }
}

