/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.graylog.shaded.opensearch22.org.opensearch.action.support.nodes;

import org.graylog.shaded.opensearch22.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch22.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch22.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch22.org.opensearch.transport.TransportRequest;

import java.io.IOException;

/**
 * Base class for node transport requests
 *
 * @opensearch.internal
 *
 * @deprecated this class is deprecated and classes will extend TransportRequest directly
 */
// TODO: this class can be removed in main once 7.x is bumped to 7.4.0
@Deprecated
public abstract class BaseNodeRequest extends TransportRequest {

    public BaseNodeRequest() {}

    public BaseNodeRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(LegacyESVersion.V_7_3_0)) {
            in.readString(); // previously nodeId
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(LegacyESVersion.V_7_3_0)) {
            out.writeString(""); // previously nodeId
        }
    }
}
