/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.surround.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch22.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch22.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch22.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.opensearch22.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.opensearch22.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch22.org.apache.lucene.search.QueryVisitor;

class SimpleTermRewriteQuery extends RewriteQuery<SimpleTerm> {

  SimpleTermRewriteQuery(SimpleTerm srndQuery, String fieldName, BasicQueryFactory qf) {
    super(srndQuery, fieldName, qf);
  }

  @Override
  public Query rewrite(IndexReader reader) throws IOException {
    final List<Query> luceneSubQueries = new ArrayList<>();
    srndQuery.visitMatchingTerms(
        reader,
        fieldName,
        new SimpleTerm.MatchingTermVisitor() {
          @Override
          public void visitMatchingTerm(Term term) throws IOException {
            luceneSubQueries.add(qf.newTermQuery(term));
          }
        });
    return (luceneSubQueries.size() == 0)
        ? new MatchNoDocsQuery()
        : (luceneSubQueries.size() == 1)
            ? luceneSubQueries.get(0)
            : SrndBooleanQuery.makeBooleanQuery(
                /* luceneSubQueries all have default weight */
                luceneSubQueries, BooleanClause.Occur.SHOULD); /* OR the subquery terms */
  }

  @Override
  public void visit(QueryVisitor visitor) {
    // TODO: implement this
    visitor.visitLeaf(this);
  }
}
