/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.standard.builders;

import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.builders.QueryTreeBuilder;
import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.nodes.ModifierQueryNode;
import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.graylog.shaded.opensearch22.org.apache.lucene.search.Query;

/**
 * Builds no object, it only returns the {@link Query} object set on the {@link ModifierQueryNode}
 * object using a {@link QueryTreeBuilder#QUERY_TREE_BUILDER_TAGID} tag.
 */
public class ModifierQueryNodeBuilder implements StandardQueryBuilder {

  public ModifierQueryNodeBuilder() {
    // empty constructor
  }

  @Override
  public Query build(QueryNode queryNode) throws QueryNodeException {
    ModifierQueryNode modifierNode = (ModifierQueryNode) queryNode;

    return (Query) (modifierNode).getChild().getTag(QueryTreeBuilder.QUERY_TREE_BUILDER_TAGID);
  }
}
