/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.standard.builders;

import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.nodes.MatchNoDocsQueryNode;
import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.messages.MessageImpl;
import org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.standard.parser.EscapeQuerySyntaxImpl;
import org.graylog.shaded.opensearch22.org.apache.lucene.search.MatchNoDocsQuery;

/** Builds a {@link MatchNoDocsQuery} object from a {@link MatchNoDocsQueryNode} object. */
public class MatchNoDocsQueryNodeBuilder implements StandardQueryBuilder {

  public MatchNoDocsQueryNodeBuilder() {
    // empty constructor
  }

  @Override
  public MatchNoDocsQuery build(QueryNode queryNode) throws QueryNodeException {

    // validates node
    if (!(queryNode instanceof MatchNoDocsQueryNode)) {
      throw new QueryNodeException(
          new MessageImpl(
              QueryParserMessages.LUCENE_QUERY_CONVERSION_ERROR,
              queryNode.toQueryString(new EscapeQuerySyntaxImpl()),
              queryNode.getClass().getName()));
    }

    return new MatchNoDocsQuery();
  }
}
