/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Core classes of the flexible query parser framework.
 *
 * <h2>Flexible Query Parser</h2>
 *
 * <p>This package contains the necessary classes to implement a query parser.
 *
 * <p>A query parser is divided in at least 2 phases, text parsing and query building, and one
 * optional phase called query processing.
 *
 * <h3>First Phase: Text Parsing</h3>
 *
 * <p>The text parsing phase is performed by a text parser, which implements {@link
 * org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.parser.SyntaxParser} interface. A text parser is
 * responsible to get a query string and convert it to a {@link
 * org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode} tree, which is an object structure
 * that represents the elements defined in the query string.
 *
 * <h3>Second (optional) Phase: Query Processing</h3>
 *
 * <p>The query processing phase is performed by a query processor, which implements {@link
 * org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessor}. A query processor is
 * responsible to perform any processing on a {@link
 * org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode} tree. This phase is optional and is
 * used only if an extra processing, validation, query expansion, etc needs to be performed in a
 * {@link org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode} tree. The {@link
 * org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode} tree can be either be generated by a
 * text parser or programmatically created.
 *
 * <h3>Third Phase: Query Building</h3>
 *
 * <p>The query building phase is performed by a query builder, which implements {@link
 * org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.builders.QueryBuilder}. A query builder is
 * responsible to convert a {@link org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode} tree
 * into an arbitrary object, which is usually used to be executed against a search index.
 */
package org.graylog.shaded.opensearch22.org.apache.lucene.queryparser.flexible.core;
