/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * The payloads package provides Query mechanisms for finding and using payloads.
 *
 * <p>The following Query implementations are provided:
 *
 * <ol>
 *   <li>{@link org.graylog.shaded.opensearch22.org.apache.lucene.queries.payloads.PayloadScoreQuery PayloadScoreQuery} -- For all
 *       terms matched by a SpanQuery, boost the score based on the value of the payload located at
 *       those terms.
 * </ol>
 */
package org.graylog.shaded.opensearch22.org.apache.lucene.queries.payloads;
