/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.graylog.shaded.opensearch22.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import org.graylog.shaded.opensearch22.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.opensearch22.org.apache.lucene.queries.function.ValueSource;

/** Function to divide "a" by "b" */
public class DivFloatFunction extends DualFloatFunction {
  /**
   * @param a the numerator.
   * @param b the denominator.
   */
  public DivFloatFunction(ValueSource a, ValueSource b) {
    super(a, b);
  }

  @Override
  protected String name() {
    return "div";
  }

  @Override
  protected float func(int doc, FunctionValues aVals, FunctionValues bVals) throws IOException {
    return aVals.floatVal(doc) / bVals.floatVal(doc);
  }
}
