/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.graylog.shaded.opensearch22.org.apache.lucene.backward_codecs.lucene70;

import org.graylog.shaded.opensearch22.org.apache.lucene.backward_codecs.lucene50.Lucene50CompoundFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.backward_codecs.lucene50.Lucene50LiveDocsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.backward_codecs.lucene50.Lucene50StoredFieldsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.backward_codecs.lucene50.Lucene50StoredFieldsFormat.Mode;
import org.graylog.shaded.opensearch22.org.apache.lucene.backward_codecs.lucene50.Lucene50TermVectorsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.backward_codecs.lucene60.Lucene60FieldInfosFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.backward_codecs.lucene60.Lucene60PointsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.CompoundFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.DocValuesFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.FieldInfosFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.FilterCodec;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.KnnVectorsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.LiveDocsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.NormsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.PointsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.PostingsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.SegmentInfoFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.StoredFieldsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.TermVectorsFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.graylog.shaded.opensearch22.org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;

/**
 * Implements the Lucene 7.0 index format, with configurable per-field postings and docvalues
 * formats.
 *
 * <p>If you want to reuse functionality of this codec in another codec, extend {@link FilterCodec}.
 *
 * @see org.graylog.shaded.opensearch22.org.apache.lucene.backward_codecs.lucene70 package documentation for file format details.
 * @lucene.experimental
 */
public class Lucene70Codec extends Codec {
  private final TermVectorsFormat vectorsFormat = new Lucene50TermVectorsFormat();
  private final FieldInfosFormat fieldInfosFormat = new Lucene60FieldInfosFormat();
  private final SegmentInfoFormat segmentInfosFormat = new Lucene70SegmentInfoFormat();
  private final LiveDocsFormat liveDocsFormat = new Lucene50LiveDocsFormat();
  private final CompoundFormat compoundFormat = new Lucene50CompoundFormat();
  private final DocValuesFormat defaultDVFormat = DocValuesFormat.forName("Lucene70");

  private final PostingsFormat postingsFormat =
      new PerFieldPostingsFormat() {
        @Override
        public PostingsFormat getPostingsFormatForField(String field) {
          throw new IllegalStateException(
              "This codec should only be used for reading, not writing");
        }
      };

  private final DocValuesFormat docValuesFormat =
      new PerFieldDocValuesFormat() {
        @Override
        public DocValuesFormat getDocValuesFormatForField(String field) {
          return defaultDVFormat;
        }
      };

  private final StoredFieldsFormat storedFieldsFormat =
      new Lucene50StoredFieldsFormat(Mode.BEST_SPEED);

  /** Instantiates a new codec. */
  public Lucene70Codec() {
    super("Lucene70");
  }

  @Override
  public StoredFieldsFormat storedFieldsFormat() {
    return storedFieldsFormat;
  }

  @Override
  public TermVectorsFormat termVectorsFormat() {
    return vectorsFormat;
  }

  @Override
  public PostingsFormat postingsFormat() {
    return postingsFormat;
  }

  @Override
  public final FieldInfosFormat fieldInfosFormat() {
    return fieldInfosFormat;
  }

  @Override
  public SegmentInfoFormat segmentInfoFormat() {
    return segmentInfosFormat;
  }

  @Override
  public final LiveDocsFormat liveDocsFormat() {
    return liveDocsFormat;
  }

  @Override
  public CompoundFormat compoundFormat() {
    return compoundFormat;
  }

  @Override
  public final PointsFormat pointsFormat() {
    return new Lucene60PointsFormat();
  }

  @Override
  public KnnVectorsFormat knnVectorsFormat() {
    return KnnVectorsFormat.EMPTY;
  }

  @Override
  public final DocValuesFormat docValuesFormat() {
    return docValuesFormat;
  }

  private final NormsFormat normsFormat = new Lucene70NormsFormat();

  @Override
  public NormsFormat normsFormat() {
    return normsFormat;
  }
}
