/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.graylog.shaded.opensearch22.org.apache.http.impl.nio;

import java.io.IOException;

import org.graylog.shaded.opensearch22.org.apache.http.HttpRequestFactory;
import org.graylog.shaded.opensearch22.org.apache.http.annotation.ThreadingBehavior;
import org.graylog.shaded.opensearch22.org.apache.http.annotation.Contract;
import org.graylog.shaded.opensearch22.org.apache.http.impl.DefaultHttpRequestFactory;
import org.graylog.shaded.opensearch22.org.apache.http.impl.nio.reactor.AbstractIODispatch;
import org.graylog.shaded.opensearch22.org.apache.http.nio.NHttpServerIOTarget;
import org.graylog.shaded.opensearch22.org.apache.http.nio.NHttpServiceHandler;
import org.graylog.shaded.opensearch22.org.apache.http.nio.reactor.IOSession;
import org.graylog.shaded.opensearch22.org.apache.http.nio.util.ByteBufferAllocator;
import org.graylog.shaded.opensearch22.org.apache.http.nio.util.HeapByteBufferAllocator;
import org.graylog.shaded.opensearch22.org.apache.http.params.HttpConnectionParams;
import org.graylog.shaded.opensearch22.org.apache.http.params.HttpParams;
import org.graylog.shaded.opensearch22.org.apache.http.util.Args;

/**
 * Default implementation of {@link org.graylog.shaded.opensearch22.org.apache.http.nio.reactor.IOEventDispatch}
 * interface for plain (unencrypted) server-side HTTP connections.
 *
 * @since 4.0
 *
 * @deprecated (4.2) use {@link DefaultHttpServerIODispatch}
 */
@Deprecated
@Contract(threading = ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultServerIOEventDispatch extends AbstractIODispatch<NHttpServerIOTarget> {

    protected final ByteBufferAllocator allocator;
    protected final NHttpServiceHandler handler;
    protected final HttpParams params;

    /**
     * Creates a new instance of this class to be used for dispatching I/O event
     * notifications to the given protocol handler.
     *
     * @param handler the server protocol handler.
     * @param params HTTP parameters.
     */
     public DefaultServerIOEventDispatch(
            final NHttpServiceHandler handler,
            final HttpParams params) {
        super();
        Args.notNull(handler, "HTTP service handler");
        Args.notNull(params, "HTTP parameters");
        this.allocator = createByteBufferAllocator();
        this.handler = handler;
        this.params = params;
    }

   /**
    * Creates an instance of {@link HeapByteBufferAllocator} to be used
    * by HTTP connections for allocating {@link java.nio.ByteBuffer} objects.
    * <p>
    * This method can be overridden in a super class in order to provide
    * a different implementation of the {@link ByteBufferAllocator} interface.
    *
    * @return byte buffer allocator.
    */
    protected ByteBufferAllocator createByteBufferAllocator() {
        return HeapByteBufferAllocator.INSTANCE;
    }

    /**
     * Creates an instance of {@link DefaultHttpRequestFactory} to be used
     * by HTTP connections for creating {@link org.graylog.shaded.opensearch22.org.apache.http.HttpRequest}
     * objects.
     * <p>
     * This method can be overridden in a super class in order to provide
     * a different implementation of the {@link HttpRequestFactory} interface.
     *
     * @return HTTP request factory.
     */
    protected HttpRequestFactory createHttpRequestFactory() {
        return DefaultHttpRequestFactory.INSTANCE;
    }

    /**
     * Creates an instance of {@link DefaultNHttpServerConnection} based on the
     * given {@link IOSession}.
     * <p>
     * This method can be overridden in a super class in order to provide
     * a different implementation of the {@link NHttpServerIOTarget} interface.
     *
     * @param session the underlying I/O session.
     *
     * @return newly created HTTP connection.
     */
    @Override
    protected NHttpServerIOTarget createConnection(final IOSession session) {
        return new DefaultNHttpServerConnection(
                session,
                createHttpRequestFactory(),
                this.allocator,
                this.params);
    }

    @Override
    protected void onConnected(final NHttpServerIOTarget conn) {
        final int timeout = HttpConnectionParams.getSoTimeout(this.params);
        conn.setSocketTimeout(timeout);
        this.handler.connected(conn);
    }

    @Override
    protected void onClosed(final NHttpServerIOTarget conn) {
        this.handler.closed(conn);
    }

    @Override
    protected void onException(final NHttpServerIOTarget conn, final IOException ex) {
        this.handler.exception(conn, ex);
    }

    @Override
    protected void onInputReady(final NHttpServerIOTarget conn) {
        conn.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(final NHttpServerIOTarget conn) {
        conn.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(final NHttpServerIOTarget conn) {
        this.handler.timeout(conn);
    }

}
