package org.graylog.shaded.opensearch22.com.github.mustachejava.codes;

import org.graylog.shaded.opensearch22.com.github.mustachejava.DefaultMustacheFactory;
import org.graylog.shaded.opensearch22.com.github.mustachejava.Mustache;
import org.graylog.shaded.opensearch22.com.github.mustachejava.TemplateContext;

import java.io.Writer;
import java.util.List;
import java.util.concurrent.Callable;

/**
 * Runs the enclosed template once if the value is falsey.
 */
public class NotIterableCode extends IterableCode {

  public NotIterableCode(TemplateContext templateContext, DefaultMustacheFactory df, Mustache mustache, String variable) {
    super(templateContext, df, mustache, variable, "^");
  }

  protected Writer handle(Writer writer, Object resolved, List<Object> scopes) {
    if (resolved instanceof Callable) {
      writer = handleCallable(writer, (Callable) resolved, scopes);
    } else {
      writer = execute(writer, resolved, scopes);
    }
    return writer;
  }

  @Override
  protected Writer execute(Writer writer, Object resolve, List<Object> scopes) {
    return oh.falsey(this, writer, resolve, scopes);
  }

  @Override
  public Writer next(Writer writer, Object object, List<Object> scopes) {
    return run(writer, scopes);
  }
}
