/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.codahale.metrics.UniformReservoir;
import com.google.common.base.MoreObjects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class MetricUtils {
    private static final Counter EMPTY_COUNTER = new Counter(){

        public void inc(long n) {
        }

        public void dec(long n) {
        }
    };
    private static final Gauge<Integer> EMPTY_INTEGER_GAUGE = new Gauge<Integer>(){

        public Integer getValue() {
            return 0;
        }
    };
    private static final Gauge<Long> EMPTY_LONG_GAUGE = new Gauge<Long>(){

        public Long getValue() {
            return 0L;
        }
    };
    private static final Gauge<Double> EMPTY_DOUBLE_GAUGE = new Gauge<Double>(){

        public Double getValue() {
            return 0.0;
        }
    };
    private static final Reservoir EMPTY_RESERVOIR = new UniformReservoir(0){

        public void update(long value) {
        }
    };
    private static final Histogram EMPTY_HISTOGRAM = new Histogram(EMPTY_RESERVOIR){

        public void update(long value) {
        }
    };
    private static final Meter EMPTY_METER = new Meter(){

        public void mark(long n) {
        }
    };
    private static final Timer EMPTY_TIMER = new Timer(){

        public void update(long duration, TimeUnit unit) {
        }

        public <T> T time(Callable<T> event) throws Exception {
            return null;
        }

        public Timer.Context time() {
            return null;
        }
    };

    private MetricUtils() {
    }

    public static Counter safeGetCounter(MetricRegistry registry, String name) {
        return (Counter)MoreObjects.firstNonNull((Object)((Counter)registry.getCounters().get(name)), (Object)EMPTY_COUNTER);
    }

    public static Gauge<Integer> safeGetIntegerGauge(MetricRegistry registry, String name) {
        return (Gauge)MoreObjects.firstNonNull((Object)((Gauge)registry.getGauges().get(name)), EMPTY_INTEGER_GAUGE);
    }

    public static Gauge<Long> safeGetLongGauge(MetricRegistry registry, String name) {
        return (Gauge)MoreObjects.firstNonNull((Object)((Gauge)registry.getGauges().get(name)), EMPTY_LONG_GAUGE);
    }

    public static Gauge<Double> safeGetDoubleGauge(MetricRegistry registry, String name) {
        return (Gauge)MoreObjects.firstNonNull((Object)((Gauge)registry.getGauges().get(name)), EMPTY_DOUBLE_GAUGE);
    }

    public static Histogram safeGetHistogram(MetricRegistry registry, String name) {
        return (Histogram)MoreObjects.firstNonNull((Object)((Histogram)registry.getHistograms().get(name)), (Object)EMPTY_HISTOGRAM);
    }

    public static Meter safeGetMeter(MetricRegistry registry, String name) {
        return (Meter)MoreObjects.firstNonNull((Object)((Meter)registry.getMeters().get(name)), (Object)EMPTY_METER);
    }

    public static Timer safeGetTimer(MetricRegistry registry, String name) {
        return (Timer)MoreObjects.firstNonNull((Object)((Timer)registry.getTimers().get(name)), (Object)EMPTY_TIMER);
    }
}

