
package org.graylog.plugins.usagestatistics.dto.elasticsearch;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog.plugins.usagestatistics.dto.HostInfo;
import org.graylog.plugins.usagestatistics.dto.JvmInfo;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ElasticsearchNodeInfo extends ElasticsearchNodeInfo {

  private final String version;
  private final HostInfo system;
  private final JvmInfo jvm;

  AutoValue_ElasticsearchNodeInfo(
      String version,
      HostInfo system,
      @Nullable JvmInfo jvm) {
    if (version == null) {
      throw new NullPointerException("Null version");
    }
    this.version = version;
    if (system == null) {
      throw new NullPointerException("Null system");
    }
    this.system = system;
    this.jvm = jvm;
  }

  @JsonProperty
  @Override
  public String version() {
    return version;
  }

  @JsonProperty
  @Override
  public HostInfo system() {
    return system;
  }

  @JsonProperty
  @Nullable
  @Override
  public JvmInfo jvm() {
    return jvm;
  }

  @Override
  public String toString() {
    return "ElasticsearchNodeInfo{"
        + "version=" + version + ", "
        + "system=" + system + ", "
        + "jvm=" + jvm
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ElasticsearchNodeInfo) {
      ElasticsearchNodeInfo that = (ElasticsearchNodeInfo) o;
      return (this.version.equals(that.version()))
           && (this.system.equals(that.system()))
           && ((this.jvm == null) ? (that.jvm() == null) : this.jvm.equals(that.jvm()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.version.hashCode();
    h *= 1000003;
    h ^= this.system.hashCode();
    h *= 1000003;
    h ^= (jvm == null) ? 0 : this.jvm.hashCode();
    return h;
  }

}
