
package org.graylog.plugins.usagestatistics.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_NodeDataSet extends NodeDataSet {

  private final String version;
  private final String clusterId;
  private final String nodeId;
  private final long timestamp;
  private final long reportIntervalMs;
  private final NodeInfo nodeInfo;
  private final NodeStats nodeStats;
  private final HostInfo hostInfo;
  private final HostStats hostStats;
  private final JvmInfo jvm;

  AutoValue_NodeDataSet(
      String version,
      String clusterId,
      String nodeId,
      long timestamp,
      long reportIntervalMs,
      NodeInfo nodeInfo,
      NodeStats nodeStats,
      HostInfo hostInfo,
      HostStats hostStats,
      JvmInfo jvm) {
    if (version == null) {
      throw new NullPointerException("Null version");
    }
    this.version = version;
    if (clusterId == null) {
      throw new NullPointerException("Null clusterId");
    }
    this.clusterId = clusterId;
    if (nodeId == null) {
      throw new NullPointerException("Null nodeId");
    }
    this.nodeId = nodeId;
    this.timestamp = timestamp;
    this.reportIntervalMs = reportIntervalMs;
    if (nodeInfo == null) {
      throw new NullPointerException("Null nodeInfo");
    }
    this.nodeInfo = nodeInfo;
    if (nodeStats == null) {
      throw new NullPointerException("Null nodeStats");
    }
    this.nodeStats = nodeStats;
    if (hostInfo == null) {
      throw new NullPointerException("Null hostInfo");
    }
    this.hostInfo = hostInfo;
    if (hostStats == null) {
      throw new NullPointerException("Null hostStats");
    }
    this.hostStats = hostStats;
    if (jvm == null) {
      throw new NullPointerException("Null jvm");
    }
    this.jvm = jvm;
  }

  @JsonProperty
  @Override
  public String version() {
    return version;
  }

  @JsonProperty
  @Override
  public String clusterId() {
    return clusterId;
  }

  @JsonProperty
  @Override
  public String nodeId() {
    return nodeId;
  }

  @JsonProperty
  @Override
  public long timestamp() {
    return timestamp;
  }

  @JsonProperty
  @Override
  public long reportIntervalMs() {
    return reportIntervalMs;
  }

  @JsonProperty
  @Override
  public NodeInfo nodeInfo() {
    return nodeInfo;
  }

  @JsonProperty
  @Override
  public NodeStats nodeStats() {
    return nodeStats;
  }

  @JsonProperty
  @Override
  public HostInfo hostInfo() {
    return hostInfo;
  }

  @JsonProperty
  @Override
  public HostStats hostStats() {
    return hostStats;
  }

  @JsonProperty
  @Override
  public JvmInfo jvm() {
    return jvm;
  }

  @Override
  public String toString() {
    return "NodeDataSet{"
        + "version=" + version + ", "
        + "clusterId=" + clusterId + ", "
        + "nodeId=" + nodeId + ", "
        + "timestamp=" + timestamp + ", "
        + "reportIntervalMs=" + reportIntervalMs + ", "
        + "nodeInfo=" + nodeInfo + ", "
        + "nodeStats=" + nodeStats + ", "
        + "hostInfo=" + hostInfo + ", "
        + "hostStats=" + hostStats + ", "
        + "jvm=" + jvm
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NodeDataSet) {
      NodeDataSet that = (NodeDataSet) o;
      return (this.version.equals(that.version()))
           && (this.clusterId.equals(that.clusterId()))
           && (this.nodeId.equals(that.nodeId()))
           && (this.timestamp == that.timestamp())
           && (this.reportIntervalMs == that.reportIntervalMs())
           && (this.nodeInfo.equals(that.nodeInfo()))
           && (this.nodeStats.equals(that.nodeStats()))
           && (this.hostInfo.equals(that.hostInfo()))
           && (this.hostStats.equals(that.hostStats()))
           && (this.jvm.equals(that.jvm()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.version.hashCode();
    h *= 1000003;
    h ^= this.clusterId.hashCode();
    h *= 1000003;
    h ^= this.nodeId.hashCode();
    h *= 1000003;
    h ^= (this.timestamp >>> 32) ^ this.timestamp;
    h *= 1000003;
    h ^= (this.reportIntervalMs >>> 32) ^ this.reportIntervalMs;
    h *= 1000003;
    h ^= this.nodeInfo.hashCode();
    h *= 1000003;
    h ^= this.nodeStats.hashCode();
    h *= 1000003;
    h ^= this.hostInfo.hashCode();
    h *= 1000003;
    h ^= this.hostStats.hashCode();
    h *= 1000003;
    h ^= this.jvm.hashCode();
    return h;
  }

}
