
package org.graylog.plugins.usagestatistics.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_MongoStats extends MongoStats {

  private final String version;
  private final int serverCount;
  private final String cpuArch;
  private final MongoDatabaseStats databaseStats;

  AutoValue_MongoStats(
      String version,
      int serverCount,
      String cpuArch,
      @Nullable MongoDatabaseStats databaseStats) {
    if (version == null) {
      throw new NullPointerException("Null version");
    }
    this.version = version;
    this.serverCount = serverCount;
    if (cpuArch == null) {
      throw new NullPointerException("Null cpuArch");
    }
    this.cpuArch = cpuArch;
    this.databaseStats = databaseStats;
  }

  @JsonProperty
  @Override
  public String version() {
    return version;
  }

  @JsonProperty
  @Override
  public int serverCount() {
    return serverCount;
  }

  @JsonProperty
  @Override
  public String cpuArch() {
    return cpuArch;
  }

  @JsonProperty
  @Nullable
  @Override
  public MongoDatabaseStats databaseStats() {
    return databaseStats;
  }

  @Override
  public String toString() {
    return "MongoStats{"
        + "version=" + version + ", "
        + "serverCount=" + serverCount + ", "
        + "cpuArch=" + cpuArch + ", "
        + "databaseStats=" + databaseStats
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MongoStats) {
      MongoStats that = (MongoStats) o;
      return (this.version.equals(that.version()))
           && (this.serverCount == that.serverCount())
           && (this.cpuArch.equals(that.cpuArch()))
           && ((this.databaseStats == null) ? (that.databaseStats() == null) : this.databaseStats.equals(that.databaseStats()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.version.hashCode();
    h *= 1000003;
    h ^= this.serverCount;
    h *= 1000003;
    h ^= this.cpuArch.hashCode();
    h *= 1000003;
    h ^= (databaseStats == null) ? 0 : this.databaseStats.hashCode();
    return h;
  }

}
