/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.graylog.plugins.usagestatistics.collectors.ClusterCollector;
import org.graylog.plugins.usagestatistics.dto.ClusterDataSet;

@Singleton
public class UsageStatsClusterService {
    private final Supplier<ClusterDataSet> cachedDataSet;

    @Inject
    public UsageStatsClusterService(ClusterCollector clusterCollector, @Named(value="usage_statistics_cache_timeout") Duration cacheTimeout) {
        this(UsageStatsClusterService.supplier(clusterCollector), cacheTimeout);
    }

    @VisibleForTesting
    UsageStatsClusterService(Supplier<ClusterDataSet> clusterDataSetSupplier, Duration cacheTimeout) {
        this.cachedDataSet = Suppliers.memoizeWithExpiration(clusterDataSetSupplier, (long)cacheTimeout.getQuantity(), (TimeUnit)cacheTimeout.getUnit());
    }

    private static Supplier<ClusterDataSet> supplier(final ClusterCollector clusterCollector) {
        return new Supplier<ClusterDataSet>(){

            public ClusterDataSet get() {
                return clusterCollector.getClusterDataSet();
            }
        };
    }

    public ClusterDataSet buildClusterDataSet() {
        return (ClusterDataSet)this.cachedDataSet.get();
    }
}

