/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nullable;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.graylog.plugins.usagestatistics.UsageStatsConfiguration;
import org.graylog.plugins.usagestatistics.UsageStatsConstants;
import org.graylog.plugins.usagestatistics.UsageStatsOptOutState;
import org.graylog.plugins.usagestatistics.providers.SmileObjectMapper;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageStatsOptOutService {
    private static final Logger LOG = LoggerFactory.getLogger(UsageStatsOptOutService.class);
    private final ClusterConfigService clusterConfigService;
    private final UsageStatsConfiguration config;
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;

    @Inject
    public UsageStatsOptOutService(ClusterConfigService clusterConfigService, UsageStatsConfiguration config, OkHttpClient httpClient, @SmileObjectMapper ObjectMapper objectMapper) {
        this.clusterConfigService = clusterConfigService;
        this.config = config;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    @Nullable
    public UsageStatsOptOutState getOptOutState() {
        return (UsageStatsOptOutState)this.clusterConfigService.get(UsageStatsOptOutState.class);
    }

    public void setOptOutState(UsageStatsOptOutState optOutState) {
        if (optOutState == null) {
            return;
        }
        LOG.debug("Writing opt-out state to cluster config: {}", (Object)optOutState);
        this.clusterConfigService.write((Object)optOutState);
        if (!optOutState.isOptOut()) {
            LOG.info("Transmission of anonymous usage stats: enabled (opt-in)");
            LOG.debug("Not sending opt-in request.");
            return;
        }
        LOG.info("Transmission of anonymous usage stats: disabled (opt-out)");
        URL url = this.getUrl();
        if (url == null) {
            LOG.debug("Not sending opt-out request, 'usage_statistics_url' is not set.");
            return;
        }
        Headers headers = new Headers.Builder().add("User-Agent", UsageStatsConstants.USER_AGENT).add("X-Usage-Statistics-Version", UsageStatsConstants.USAGE_STATS_VERSION).build();
        Request request = new Request.Builder().url(url).headers(headers).post(RequestBody.create((MediaType)UsageStatsConstants.CONTENT_TYPE, (byte[])this.buildPayload())).build();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                LOG.error("Error while sending anonymous usage statistics opt-out");
                LOG.debug("Error details", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    LOG.warn("Couldn't successfully send usage statistics opt-out: {}", (Object)response);
                }
            }
        });
    }

    @Nullable
    protected URL getUrl() {
        ClusterId clusterId = (ClusterId)this.clusterConfigService.get(ClusterId.class);
        if (clusterId != null) {
            return HttpUrl.get((URI)this.config.getUrl()).newBuilder().addPathSegment("cluster").addPathSegment(clusterId.clusterId()).addPathSegment("optout").build().url();
        }
        return null;
    }

    @Nullable
    protected byte[] buildPayload() {
        try {
            return this.objectMapper.writeValueAsBytes((Object)ImmutableMap.builder().build());
        }
        catch (JsonProcessingException e) {
            LOG.error("Error while serializing usage statistics data", (Throwable)e);
            return null;
        }
    }
}

