/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.shaded.jackson.smile.async;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.graylog.plugins.usagestatistics.shaded.jackson.smile.PackageVersion;
import org.graylog.plugins.usagestatistics.shaded.jackson.smile.SmileBufferRecycler;
import org.graylog.plugins.usagestatistics.shaded.jackson.smile.SmileConstants;
import org.graylog.plugins.usagestatistics.shaded.jackson.smile.SmileParser;
import org.graylog.plugins.usagestatistics.shaded.jackson.smile.SmileUtil;
import org.graylog.plugins.usagestatistics.shaded.jackson.smile.async.NonBlockingInputFeeder;
import org.graylog.plugins.usagestatistics.shaded.jackson.smile.async.NonBlockingParser;

public class NonBlockingParserImpl
extends ParserBase
implements NonBlockingParser,
NonBlockingInputFeeder {
    private static final byte[] NO_BYTES = new byte[0];
    private static final int[] NO_INTS = new int[0];
    private static final String[] NO_STRINGS = new String[0];
    protected static final int STATE_INITIAL = 0;
    protected static final int STATE_HEADER = 1;
    protected static final int STATE_TOKEN_COMPLETE = 2;
    protected static final int STATE_NUMBER_INT = 10;
    protected static final int STATE_NUMBER_LONG = 11;
    protected static final int STATE_NUMBER_BIGINT = 12;
    protected static final int STATE_NUMBER_FLOAT = 13;
    protected static final int STATE_NUMBER_DOUBLE = 14;
    protected static final int STATE_NUMBER_BIGDEC = 15;
    protected static final int STATE_SHORT_ASCII = 20;
    protected static final int STATE_SHORT_UNICODE = 21;
    protected static final int STATE_LONG_ASCII = 22;
    protected static final int STATE_LONG_UNICODE = 23;
    protected static final int STATE_LONG_SHARED = 24;
    protected static final int STATE_RAW_BINARY = 25;
    protected static final int STATE_QUOTED_BINARY = 26;
    protected ObjectCodec _objectCodec;
    protected boolean _mayContainRawBinary;
    protected final boolean _cfgRequireHeader;
    protected final SmileBufferRecycler<String> _smileBufferRecycler;
    protected byte[] _inputBuffer = NO_BYTES;
    protected int _origBufferLen;
    protected int _state;
    protected int _substate;
    protected boolean _tokenIncomplete;
    protected boolean _got32BitFloat;
    protected int _pendingInt;
    protected long _pendingLong;
    protected boolean _endOfInput = false;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quadCount;
    protected int _currQuad;
    protected int _currQuadBytes = 0;
    protected String[] _seenNames = NO_STRINGS;
    protected int _seenNameCount = 0;
    protected String[] _seenStringValues = null;
    protected int _seenStringValueCount = -1;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<String>>> _smileRecyclerRef = new ThreadLocal();
    private int _quad1;
    private int _quad2;

    public NonBlockingParserImpl(IOContext ctxt, int parserFeatures, int smileFeatures, ObjectCodec codec, ByteQuadsCanonicalizer sym) {
        super(ctxt, parserFeatures);
        this._objectCodec = codec;
        this._symbols = sym;
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
        this._smileBufferRecycler = NonBlockingParserImpl._smileBufferRecycler();
        this._currToken = JsonToken.NOT_AVAILABLE;
        this._state = 0;
        this._tokenIncomplete = true;
        this._cfgRequireHeader = (smileFeatures & SmileParser.Feature.REQUIRE_HEADER.getMask()) != 0;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    protected boolean handleSignature(boolean consumeFirstByte, boolean throwException) throws IOException, JsonParseException {
        byte ch;
        int versionBits;
        if (consumeFirstByte) {
            ++this._inputPtr;
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 41) {
            if (throwException) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0x29");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (this._inputBuffer[this._inputPtr] != 10) {
            if (throwException) {
                this._reportError("Malformed content: signature not valid, starts with 0x3a, 0x29, but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr]) + ", not 0xA");
            }
            return false;
        }
        if (++this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((versionBits = (ch = this._inputBuffer[this._inputPtr++]) >> 4 & 0xF) != 0) {
            this._reportError("Header version number bits (0x" + Integer.toHexString(versionBits) + ") indicate unrecognized version; only 0x0 handled by parser");
        }
        if ((ch & 1) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        }
        if ((ch & 2) != 0) {
            this._seenStringValues = NO_STRINGS;
            this._seenStringValueCount = 0;
        }
        this._mayContainRawBinary = (ch & 4) != 0;
        return true;
    }

    protected static final SmileBufferRecycler<String> _smileBufferRecycler() {
        SmileBufferRecycler<String> br;
        SoftReference<SmileBufferRecycler<String>> ref = _smileRecyclerRef.get();
        SmileBufferRecycler<String> smileBufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<String>>(br));
        }
        return br;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public int releaseBuffered(OutputStream out) throws IOException {
        int count = this._inputEnd - this._inputPtr;
        if (count < 1) {
            return 0;
        }
        int origPtr = this._inputPtr;
        out.write(this._inputBuffer, origPtr, count);
        return count;
    }

    @Override
    public Object getInputSource() {
        return null;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._ioContext.getSourceReference(), this._tokenInputTotal, -1L, -1, (int)this._tokenInputTotal);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        long offset = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.getSourceReference(), offset, -1L, -1, (int)offset);
    }

    @Override
    protected final boolean loadMore() throws IOException {
        this._throwInternal();
        return false;
    }

    protected final boolean _loadToHaveAtLeast(int minAvailable) throws IOException {
        this._throwInternal();
        return false;
    }

    @Override
    protected void _closeInput() throws IOException {
    }

    @Override
    protected void _finishString() throws IOException, JsonParseException {
        this._throwInternal();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        Object[] valueBuf;
        super._releaseBuffers();
        Object[] nameBuf = this._seenNames;
        if (nameBuf != null && nameBuf.length > 0) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(nameBuf, 0, this._seenNameCount, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((String[])nameBuf);
        }
        if ((valueBuf = this._seenStringValues) != null && valueBuf.length > 0) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(valueBuf, 0, this._seenStringValueCount, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((String[])valueBuf);
        }
    }

    public boolean mayContainRawBinary() {
        return this._mayContainRawBinary;
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            return this._finishToken();
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        if (this._parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
            this._currToken = this._handleFieldName();
            return this._currToken;
        }
        if (this._inputPtr >= this._inputEnd) {
            return JsonToken.NOT_AVAILABLE;
        }
        byte ch = this._inputBuffer[this._inputPtr++];
        block0 : switch (ch >> 5 & 7) {
            case 0: {
                if (ch == 0) {
                    this._reportError("Invalid token byte 0x00");
                }
                return this._handleSharedString(ch - 1);
            }
            case 1: {
                this._numTypesValid = 0;
                switch (ch & 0x1F) {
                    case 0: {
                        this._textBuffer.resetWithEmpty();
                        this._currToken = JsonToken.VALUE_STRING;
                        return this._currToken;
                    }
                    case 1: {
                        this._currToken = JsonToken.VALUE_NULL;
                        return this._currToken;
                    }
                    case 2: {
                        this._currToken = JsonToken.VALUE_FALSE;
                        return this._currToken;
                    }
                    case 3: {
                        this._currToken = JsonToken.VALUE_TRUE;
                        return this._currToken;
                    }
                    case 4: {
                        this._state = 10;
                        return this._nextInt(0, 0);
                    }
                    case 5: {
                        this._numberLong = 0L;
                        this._state = 11;
                        return this._nextLong(0, 0L);
                    }
                    case 6: {
                        this._state = 12;
                        return this._nextBigInt(0);
                    }
                    case 7: {
                        break block0;
                    }
                    case 8: {
                        this._pendingInt = 0;
                        this._state = 13;
                        this._got32BitFloat = true;
                        return this._nextFloat(0, 0);
                    }
                    case 9: {
                        this._pendingLong = 0L;
                        this._state = 14;
                        this._got32BitFloat = false;
                        return this._nextDouble(0, 0L);
                    }
                    case 10: {
                        this._state = 15;
                        return this._nextBigDecimal(0);
                    }
                    case 11: {
                        break block0;
                    }
                    case 26: {
                        if (!this._handleHeader(0)) {
                            return JsonToken.NOT_AVAILABLE;
                        }
                        if (this._currToken == null) {
                            return this.nextToken();
                        }
                        this._currToken = null;
                        return null;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                return this._nextShortAscii(0);
            }
            case 4: 
            case 5: {
                this._currToken = JsonToken.VALUE_STRING;
                if (this._seenStringValueCount >= 0) {
                    this._addSeenStringValue();
                } else {
                    this._tokenIncomplete = true;
                }
                return this._nextShortUnicode(0);
            }
            case 6: {
                this._numberInt = SmileUtil.zigzagDecode(ch & 0x1F);
                this._numTypesValid = 1;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 7: {
                switch (ch & 0x1F) {
                    case 0: {
                        return this._nextLongAscii(0);
                    }
                    case 4: {
                        return this._nextLongUnicode(0);
                    }
                    case 8: {
                        return this._nextQuotedBinary(0);
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        return this._nextLongSharedString(0);
                    }
                    case 24: {
                        this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                        this._currToken = JsonToken.START_ARRAY;
                        return this._currToken;
                    }
                    case 25: {
                        if (!this._parsingContext.inArray()) {
                            this._reportMismatchedEndMarker(93, '}');
                        }
                        this._parsingContext = this._parsingContext.getParent();
                        this._currToken = JsonToken.END_ARRAY;
                        return this._currToken;
                    }
                    case 26: {
                        this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                        this._currToken = JsonToken.START_OBJECT;
                        return this._currToken;
                    }
                    case 27: {
                        this._reportError("Invalid type marker byte 0xFB in value mode (would be END_OBJECT in key mode)");
                    }
                    case 29: {
                        return this._nextRawBinary(0);
                    }
                    case 31: {
                        this._currToken = null;
                        return null;
                    }
                }
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(ch & 0xFF) + " for expected value token");
        return null;
    }

    private final JsonToken _handleSharedString(int index) throws IOException, JsonParseException {
        if (index >= this._seenStringValueCount) {
            this._reportInvalidSharedStringValue(index);
        }
        this._textBuffer.resetWithString(this._seenStringValues[index]);
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    private final void _addSeenStringValue() throws IOException, JsonParseException {
        this._finishToken();
        if (this._seenStringValueCount < this._seenStringValues.length) {
            this._seenStringValues[this._seenStringValueCount++] = this._textBuffer.contentsAsString();
            return;
        }
        this._expandSeenStringValues();
    }

    private final void _expandSeenStringValues() {
        String[] newShared;
        String[] oldShared = this._seenStringValues;
        int len = oldShared.length;
        if (len == 0) {
            newShared = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (newShared == null) {
                newShared = new String[64];
            }
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenStringValueCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = new String[newSize];
            System.arraycopy(oldShared, 0, newShared, 0, oldShared.length);
        }
        this._seenStringValues = newShared;
        this._seenStringValues[this._seenStringValueCount++] = this._textBuffer.contentsAsString();
    }

    @Override
    public String getCurrentName() throws IOException, JsonParseException {
        return this._parsingContext.getCurrentName();
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        if (this._got32BitFloat) {
            return JsonParser.NumberType.FLOAT;
        }
        return super.getNumberType();
    }

    @Override
    public final boolean needMoreInput() {
        return this._inputPtr >= this._inputEnd && !this._endOfInput;
    }

    @Override
    public void feedInput(byte[] buf, int start, int len) throws IOException {
        if (this._inputPtr < this._inputEnd) {
            throw new IOException("Still have " + (this._inputEnd - this._inputPtr) + " undecoded bytes, should not call 'feedInput'");
        }
        if (this._endOfInput) {
            throw new IOException("Already closed, can not feed more input");
        }
        this._currInputProcessed += (long)this._origBufferLen;
        this._currInputRowStart -= this._origBufferLen;
        this._inputBuffer = buf;
        this._inputPtr = start;
        this._inputEnd = start + len;
        this._origBufferLen = len;
    }

    @Override
    public void endOfInput() {
        this._endOfInput = true;
    }

    @Override
    public JsonToken peekNextToken() throws IOException, JsonParseException {
        if (!this._tokenIncomplete) {
            return JsonToken.NOT_AVAILABLE;
        }
        switch (this._state) {
            case 0: {
                return JsonToken.NOT_AVAILABLE;
            }
            case 1: {
                return JsonToken.NOT_AVAILABLE;
            }
            case 10: 
            case 11: {
                return JsonToken.VALUE_NUMBER_INT;
            }
            case 13: 
            case 14: 
            case 15: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
        }
        throw new IllegalStateException("Internal error: unknown 'state', " + this._state);
    }

    private final JsonToken _nextInt(int substate, int value) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) < 0) {
                value = value << 6 | b & 0x3F;
                this._numberInt = SmileUtil.zigzagDecode(value);
                this._numTypesValid = 1;
                this._tokenIncomplete = false;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            if (++substate >= 5) {
                this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
            }
            value = value << 7 | b;
        }
        this._tokenIncomplete = true;
        this._substate = substate;
        this._pendingInt = value;
        this._state = 10;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextLong(int substate, long value) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte b;
            if ((b = this._inputBuffer[this._inputPtr++]) < 0) {
                value = value << 6 | (long)(b & 0x3F);
                this._numberLong = SmileUtil.zigzagDecode(value);
                this._numTypesValid = 2;
                this._tokenIncomplete = false;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            if (++substate >= 10) {
                this._reportError("Corrupt input; 64-bit VInt extends beyond 10 data bytes");
            }
            value = value << 7 | (long)b;
        }
        this._tokenIncomplete = true;
        this._substate = substate;
        this._pendingLong = value;
        this._state = 11;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextBigInt(int substate) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._substate = substate;
        this._state = 15;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextFloat(int substate, int value) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte b = this._inputBuffer[this._inputPtr++];
            value = (value << 7) + b;
            if (++substate != 5) continue;
            this._numberDouble = Float.intBitsToFloat(value);
            this._numTypesValid = 8;
            this._tokenIncomplete = false;
            this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
            return this._currToken;
        }
        this._tokenIncomplete = true;
        this._substate = substate;
        this._pendingInt = value;
        this._state = 13;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextDouble(int substate, long value) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte b = this._inputBuffer[this._inputPtr++];
            value = (value << 7) + (long)b;
            if (++substate != 10) continue;
            this._numberDouble = Double.longBitsToDouble(value);
            this._numTypesValid = 8;
            this._tokenIncomplete = false;
            this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
            return this._currToken;
        }
        this._tokenIncomplete = true;
        this._substate = substate;
        this._pendingLong = value;
        this._state = 14;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextBigDecimal(int substate) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._substate = substate;
        this._state = 15;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final boolean _handleHeader(int substate) throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd) {
            byte b = this._inputBuffer[this._inputPtr++];
            switch (substate) {
                case 0: {
                    if (b == 41) break;
                    this._reportError("Malformed content: header signature not valid, starts with 0x3a but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr] & 0xFF) + ", not 0x29");
                    break;
                }
                case 1: {
                    if (b == 10) break;
                    this._reportError("Malformed content: signature not valid, starts with 0x3a, 0x29, but followed by 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr & 0xFF]) + ", not 0x0A");
                    break;
                }
                case 2: {
                    int versionBits = b >> 4 & 0xF;
                    if (versionBits != 0) {
                        this._reportError("Header version number bits (0x" + Integer.toHexString(versionBits) + ") indicate unrecognized version; only 0x0 handled by parser");
                    }
                    if ((b & 1) == 0) {
                        this._seenNames = null;
                        this._seenNameCount = -1;
                    }
                    if ((b & 2) != 0) {
                        this._seenStringValues = NO_STRINGS;
                        this._seenStringValueCount = 0;
                    }
                    this._mayContainRawBinary = (b & 4) != 0;
                    this._tokenIncomplete = false;
                    return true;
                }
            }
        }
        this._tokenIncomplete = true;
        this._state = 1;
        this._substate = substate;
        return false;
    }

    private final JsonToken _nextShortAscii(int substate) throws IOException, JsonParseException {
        this._state = 20;
        this._tokenIncomplete = true;
        this._substate = substate;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextShortUnicode(int substate) throws IOException, JsonParseException {
        this._state = 21;
        this._tokenIncomplete = true;
        this._substate = substate;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextLongAscii(int substate) throws IOException, JsonParseException {
        this._state = 22;
        this._tokenIncomplete = true;
        this._substate = substate;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextLongUnicode(int substate) throws IOException, JsonParseException {
        this._state = 23;
        this._tokenIncomplete = true;
        this._substate = substate;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextLongSharedString(int substate) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._state = 24;
        this._substate = substate;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextRawBinary(int substate) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._state = 25;
        this._substate = substate;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _nextQuotedBinary(int substate) throws IOException, JsonParseException {
        this._tokenIncomplete = true;
        this._state = 26;
        this._substate = substate;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    @Override
    public String getText() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (this._tokenIncomplete) {
            return null;
        }
        JsonToken t = this._currToken;
        if (t == null) {
            return null;
        }
        if (t == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName();
        }
        if (t.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.getTextBuffer();
                }
                case FIELD_NAME: {
                    if (!this._nameCopied) {
                        String name = this._parsingContext.getCurrentName();
                        int nameLen = name.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(nameLen);
                        } else if (this._nameCopyBuffer.length < nameLen) {
                            this._nameCopyBuffer = new char[nameLen];
                        }
                        name.getChars(0, nameLen, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().toCharArray();
                }
            }
            if (this._tokenIncomplete) {
                return null;
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException, JsonParseException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                return -1;
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.size();
                }
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().length();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return this._binaryValue;
    }

    @Override
    public Object getEmbeddedObject() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws IOException, JsonParseException {
        throw new UnsupportedOperationException();
    }

    protected final JsonToken _handleFieldName() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int ch = this._inputBuffer[this._inputPtr++];
        switch (ch >> 6 & 3) {
            case 0: {
                switch (ch) {
                    case 32: {
                        this._parsingContext.setCurrentName("");
                        return JsonToken.FIELD_NAME;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int index;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((index = ((ch & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(index);
                        }
                        this._parsingContext.setCurrentName(this._seenNames[index]);
                        return JsonToken.FIELD_NAME;
                    }
                    case 52: {
                        this._handleLongFieldName();
                        return JsonToken.FIELD_NAME;
                    }
                }
                break;
            }
            case 1: {
                int index = ch & 0x3F;
                if (index >= this._seenNameCount) {
                    this._reportInvalidSharedName(index);
                }
                this._parsingContext.setCurrentName(this._seenNames[index]);
                return JsonToken.FIELD_NAME;
            }
            case 2: {
                int len = 1 + (ch & 0x3F);
                String name = this._findDecodedFromSymbols(len);
                if (name != null) {
                    this._inputPtr += len;
                } else {
                    name = this._decodeShortAsciiName(len);
                    name = this._addDecodedToSymbols(len, name);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._parsingContext.setCurrentName(name);
                return JsonToken.FIELD_NAME;
            }
            case 3: {
                if ((ch &= 0x3F) > 55) {
                    if (ch != 59) break;
                    if (!this._parsingContext.inObject()) {
                        this._reportMismatchedEndMarker(125, ']');
                    }
                    this._parsingContext = this._parsingContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                int len = ch + 2;
                String name = this._findDecodedFromSymbols(len);
                if (name != null) {
                    this._inputPtr += len;
                } else {
                    name = this._decodeShortUnicodeName(len);
                    name = this._addDecodedToSymbols(len, name);
                }
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = name;
                }
                this._parsingContext.setCurrentName(name);
                return JsonToken.FIELD_NAME;
            }
        }
        this._reportError("Invalid type marker byte 0x" + Integer.toHexString(this._inputBuffer[this._inputPtr - 1]) + " for expected field name (or END_OBJECT marker)");
        return null;
    }

    private final String[] _expandSeenNames(String[] oldShared) {
        String[] newShared;
        int len = oldShared.length;
        if (len == 0) {
            newShared = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (newShared == null) {
                newShared = new String[64];
            }
        } else if (len == 1024) {
            newShared = oldShared;
            this._seenNameCount = 0;
        } else {
            int newSize = len == 64 ? 256 : 1024;
            newShared = new String[newSize];
            System.arraycopy(oldShared, 0, newShared, 0, oldShared.length);
        }
        return newShared;
    }

    private final String _addDecodedToSymbols(int len, String name) {
        if (len < 5) {
            return this._symbols.addName(name, this._quad1, 0);
        }
        if (len < 9) {
            return this._symbols.addName(name, this._quad1, this._quad2);
        }
        int qlen = len + 3 >> 2;
        return this._symbols.addName(name, this._quadBuffer, qlen);
    }

    private final String _decodeShortAsciiName(int len) throws IOException, JsonParseException {
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        byte[] inBuf = this._inputBuffer;
        int inPtr = this._inputPtr;
        int inEnd = inPtr + len - 3;
        while (inPtr < inEnd) {
            outBuf[outPtr++] = (char)inBuf[inPtr++];
            outBuf[outPtr++] = (char)inBuf[inPtr++];
            outBuf[outPtr++] = (char)inBuf[inPtr++];
            outBuf[outPtr++] = (char)inBuf[inPtr++];
        }
        int left = len & 3;
        if (left > 0) {
            outBuf[outPtr++] = (char)inBuf[inPtr++];
            if (left > 1) {
                outBuf[outPtr++] = (char)inBuf[inPtr++];
                if (left > 2) {
                    outBuf[outPtr++] = (char)inBuf[inPtr++];
                }
            }
        }
        this._inputPtr = inPtr;
        this._textBuffer.setCurrentLength(len);
        return this._textBuffer.contentsAsString();
    }

    private final String _decodeShortUnicodeName(int len) throws IOException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int inPtr = this._inputPtr;
        this._inputPtr += len;
        int[] codes = SmileConstants.sUtf8UnitLengths;
        byte[] inBuf = this._inputBuffer;
        int end = inPtr + len;
        while (inPtr < end) {
            int i;
            int code;
            if ((code = codes[i = inBuf[inPtr++] & 0xFF]) != 0) {
                switch (code) {
                    case 1: {
                        i = (i & 0x1F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 2: {
                        i = (i & 0xF) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 3: {
                        i = (i & 7) << 18 | (inBuf[inPtr++] & 0x3F) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(i) + " in short Unicode text block");
                    }
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        this._textBuffer.setCurrentLength(outPtr);
        return this._textBuffer.contentsAsString();
    }

    private final String _decodeLongUnicodeName(int[] quads, int byteLen, int quadLen) throws IOException {
        int lastQuad;
        int lastQuadBytes = byteLen & 3;
        if (lastQuadBytes < 4) {
            lastQuad = quads[quadLen - 1];
            quads[quadLen - 1] = lastQuad << (4 - lastQuadBytes << 3);
        } else {
            lastQuad = 0;
        }
        char[] cbuf = this._textBuffer.emptyAndGetCurrentSegment();
        int cix = 0;
        int ix = 0;
        while (ix < byteLen) {
            int ch = quads[ix >> 2];
            int byteIx = ix & 3;
            ch = ch >> (3 - byteIx << 3) & 0xFF;
            ++ix;
            if (ch > 127) {
                int needed;
                if ((ch & 0xE0) == 192) {
                    ch &= 0x1F;
                    needed = 1;
                } else if ((ch & 0xF0) == 224) {
                    ch &= 0xF;
                    needed = 2;
                } else if ((ch & 0xF8) == 240) {
                    ch &= 7;
                    needed = 3;
                } else {
                    this._reportInvalidInitial(ch);
                    ch = 1;
                    needed = 1;
                }
                if (ix + needed > byteLen) {
                    this._reportInvalidEOF(" in long field name");
                }
                int ch2 = quads[ix >> 2];
                byteIx = ix & 3;
                ++ix;
                if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(ch2);
                }
                ch = ch << 6 | ch2 & 0x3F;
                if (needed > 1) {
                    ch2 = quads[ix >> 2];
                    byteIx = ix & 3;
                    ++ix;
                    if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 2) {
                        ch2 = quads[ix >> 2];
                        byteIx = ix & 3;
                        ++ix;
                        if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(ch2 & 0xFF);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                    }
                }
                if (needed > 2) {
                    ch -= 65536;
                    if (cix >= cbuf.length) {
                        cbuf = this._textBuffer.expandCurrentSegment();
                    }
                    cbuf[cix++] = (char)(55296 + (ch >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                }
            }
            if (cix >= cbuf.length) {
                cbuf = this._textBuffer.expandCurrentSegment();
            }
            cbuf[cix++] = (char)ch;
        }
        String baseName = new String(cbuf, 0, cix);
        if (lastQuadBytes < 4) {
            quads[quadLen - 1] = lastQuad;
        }
        return this._symbols.addName(baseName, quads, quadLen);
    }

    private final void _handleLongFieldName() throws IOException, JsonParseException {
        String name;
        byte[] inBuf = this._inputBuffer;
        int quads = 0;
        int bytes = 0;
        int q = 0;
        while (true) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 0;
                break;
            }
            q = b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 1;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 2;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (-4 == (b = inBuf[this._inputPtr++])) {
                bytes = 3;
                break;
            }
            q = q << 8 | b & 0xFF;
            if (quads >= this._quadBuffer.length) {
                this._quadBuffer = NonBlockingParserImpl._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[quads++] = q;
        }
        int byteLen = quads << 2;
        if (bytes > 0) {
            if (quads >= this._quadBuffer.length) {
                this._quadBuffer = NonBlockingParserImpl._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[quads++] = q;
            byteLen += bytes;
        }
        if ((name = this._symbols.findName(this._quadBuffer, quads)) == null) {
            name = this._decodeLongUnicodeName(this._quadBuffer, byteLen, quads);
        }
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = name;
        }
        this._parsingContext.setCurrentName(name);
    }

    private final String _findDecodedFromSymbols(int len) throws IOException {
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (len < 5) {
            int inPtr = this._inputPtr;
            byte[] inBuf = this._inputBuffer;
            int q = inBuf[inPtr] & 0xFF;
            if (--len > 0) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (--len > 0) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    if (--len > 0) {
                        q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q;
            return this._symbols.findName(q);
        }
        if (len < 9) {
            int inPtr = this._inputPtr;
            byte[] inBuf = this._inputBuffer;
            int q1 = (inBuf[inPtr] & 0xFF) << 8;
            q1 += inBuf[++inPtr] & 0xFF;
            q1 <<= 8;
            q1 += inBuf[++inPtr] & 0xFF;
            q1 <<= 8;
            q1 += inBuf[++inPtr] & 0xFF;
            int q2 = inBuf[++inPtr] & 0xFF;
            if ((len -= 5) > 0) {
                q2 = (q2 << 8) + (inBuf[++inPtr] & 0xFF);
                if (--len > 0) {
                    q2 = (q2 << 8) + (inBuf[++inPtr] & 0xFF);
                    if (--len > 0) {
                        q2 = (q2 << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            return this._symbols.findName(q1, q2);
        }
        return this._findDecodedMedium(len);
    }

    private final String _findDecodedMedium(int len) throws IOException, JsonParseException {
        int q;
        int bufLen = len + 3 >> 2;
        if (bufLen > this._quadBuffer.length) {
            this._quadBuffer = NonBlockingParserImpl._growArrayTo(this._quadBuffer, bufLen);
        }
        int offset = 0;
        int inPtr = this._inputPtr;
        byte[] inBuf = this._inputBuffer;
        do {
            q = (inBuf[inPtr++] & 0xFF) << 8;
            q |= inBuf[inPtr++] & 0xFF;
            q <<= 8;
            q |= inBuf[inPtr++] & 0xFF;
            q <<= 8;
            this._quadBuffer[offset++] = q |= inBuf[inPtr++] & 0xFF;
        } while ((len -= 4) > 3);
        if (len > 0) {
            q = inBuf[inPtr] & 0xFF;
            if (--len > 0) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (--len > 0) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                }
            }
            this._quadBuffer[offset++] = q;
        }
        return this._symbols.findName(this._quadBuffer, offset);
    }

    private static int[] _growArrayTo(int[] arr, int minSize) {
        int size = minSize + 4;
        if (arr == null) {
            return new int[size];
        }
        return Arrays.copyOf(arr, size);
    }

    @Override
    protected void _parseNumericValue(int expType) throws IOException {
        if (this._tokenIncomplete) {
            this._reportError("No current token available, can not call accessors");
        }
    }

    protected final JsonToken _finishToken() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            return JsonToken.NOT_AVAILABLE;
        }
        byte b = this._inputBuffer[this._inputPtr++];
        if (this._state == 0) {
            if (b == 58) {
                if (!this._handleHeader(0)) {
                    return JsonToken.NOT_AVAILABLE;
                }
                if (this._inputPtr >= this._inputEnd) {
                    return JsonToken.NOT_AVAILABLE;
                }
                b = this._inputBuffer[this._inputPtr++];
            } else if (this._cfgRequireHeader) {
                String msg = b == 123 || b == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(b & 0xFF) + ") -- rather, it starts with '" + (char)b + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(b & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
                throw new JsonParseException(msg, JsonLocation.NA);
            }
        } else if (this._state == 1) {
            if (!this._handleHeader(this._substate)) {
                return JsonToken.NOT_AVAILABLE;
            }
            if (this._inputPtr >= this._inputEnd) {
                return JsonToken.NOT_AVAILABLE;
            }
            b = this._inputBuffer[this._inputPtr++];
        }
        switch (this._state) {
            case 10: {
                return this._nextInt(this._substate, this._pendingInt);
            }
            case 11: {
                return this._nextLong(this._substate, this._pendingLong);
            }
            case 12: {
                return this._nextBigInt(this._substate);
            }
            case 13: {
                return this._nextFloat(this._substate, this._pendingInt);
            }
            case 14: {
                return this._nextDouble(this._substate, this._pendingLong);
            }
            case 15: {
                return this._nextBigDecimal(this._substate);
            }
        }
        this._throwInvalidState("Illegal state when trying to complete token: ");
        return null;
    }

    protected void _reportInvalidSharedName(int index) throws IOException {
        if (this._seenNames == null) {
            this._reportError("Encountered shared name reference, even though document header explicitly declared no shared name references are included");
        }
        this._reportError("Invalid shared name reference " + index + "; only got " + this._seenNameCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidSharedStringValue(int index) throws IOException {
        if (this._seenStringValues == null) {
            this._reportError("Encountered shared text value reference, even though document header did not declared shared text value references may be included");
        }
        this._reportError("Invalid shared text value reference " + index + "; only got " + this._seenStringValueCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidChar(int c) throws JsonParseException {
        if (c < 32) {
            this._throwInvalidSpace(c);
        }
        this._reportInvalidInitial(c);
    }

    protected void _reportInvalidInitial(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }

    protected void _throwInvalidState(String desc) {
        throw new IllegalStateException(desc + ": state=" + this._state);
    }
}

