/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.dto;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.graylog.plugins.usagestatistics.dto.AutoValue_Histogram;

@JsonAutoDetect
public abstract class Histogram {
    public static Histogram create(long count, long min, long max, double mean, double p50, double p75, double p95, double p98, double p99, double p999, double stddev) {
        return new AutoValue_Histogram(count, min, max, mean, p50, p75, p95, p98, p99, p999, stddev);
    }

    public static Histogram fromMetricsTimer(Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        return Histogram.create(timer.getCount(), snapshot.getMin(), snapshot.getMax(), snapshot.getMean(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get98thPercentile(), snapshot.get99thPercentile(), snapshot.get999thPercentile(), snapshot.getStdDev());
    }

    public static Histogram fromMetricsHistogram(com.codahale.metrics.Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        return Histogram.create(histogram.getCount(), snapshot.getMin(), snapshot.getMax(), snapshot.getMean(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get98thPercentile(), snapshot.get99thPercentile(), snapshot.get999thPercentile(), snapshot.getStdDev());
    }

    @JsonProperty
    public abstract long count();

    @JsonProperty
    public abstract long min();

    @JsonProperty
    public abstract long max();

    @JsonProperty
    public abstract double mean();

    @JsonProperty
    public abstract double p50();

    @JsonProperty
    public abstract double p75();

    @JsonProperty
    public abstract double p95();

    @JsonProperty
    public abstract double p98();

    @JsonProperty
    public abstract double p99();

    @JsonProperty
    public abstract double p999();

    @JsonProperty
    public abstract double stddev();
}

