/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.collectors;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.plugins.usagestatistics.UsageStatsMetaData;
import org.graylog.plugins.usagestatistics.collectors.CollectorCollector;
import org.graylog.plugins.usagestatistics.collectors.ElasticsearchCollector;
import org.graylog.plugins.usagestatistics.collectors.MongoCollector;
import org.graylog.plugins.usagestatistics.dto.ClusterDataSet;
import org.graylog.plugins.usagestatistics.dto.LdapStats;
import org.graylog2.indexer.counts.Counts;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.system.stats.AlarmStats;
import org.graylog2.system.stats.ClusterStats;
import org.graylog2.system.stats.ClusterStatsService;

public class ClusterCollector {
    private final ClusterStatsService clusterStatsService;
    private final ElasticsearchCollector elasticsearchCollector;
    private final MongoCollector mongoCollector;
    private final CollectorCollector collectorCollector;
    private final Counts counts;
    private final ClusterConfigService clusterConfigService;
    private final long reportIntervalMs;

    @Inject
    public ClusterCollector(ClusterStatsService clusterStatsService, ElasticsearchCollector elasticsearchCollector, MongoCollector mongoCollector, CollectorCollector collectorCollector, Counts counts, @Named(value="usage_statistics_report_interval") Duration reportInterval, ClusterConfigService clusterConfigService) {
        this.clusterStatsService = (ClusterStatsService)Preconditions.checkNotNull((Object)clusterStatsService);
        this.elasticsearchCollector = (ElasticsearchCollector)Preconditions.checkNotNull((Object)elasticsearchCollector);
        this.mongoCollector = (MongoCollector)Preconditions.checkNotNull((Object)mongoCollector);
        this.collectorCollector = (CollectorCollector)Preconditions.checkNotNull((Object)collectorCollector);
        this.counts = (Counts)Preconditions.checkNotNull((Object)counts);
        this.reportIntervalMs = ((Duration)Preconditions.checkNotNull((Object)reportInterval)).toMilliseconds();
        this.clusterConfigService = (ClusterConfigService)Preconditions.checkNotNull((Object)clusterConfigService);
    }

    public ClusterDataSet getClusterDataSet() {
        ClusterId clusterId = (ClusterId)this.clusterConfigService.getOrDefault(ClusterId.class, (Object)ClusterId.create((String)""));
        return ClusterDataSet.create(String.valueOf(UsageStatsMetaData.VERSION), clusterId.clusterId(), System.currentTimeMillis(), this.reportIntervalMs, this.buildClusterStats());
    }

    private org.graylog.plugins.usagestatistics.dto.ClusterStats buildClusterStats() {
        ClusterStats clusterStats = this.clusterStatsService.clusterStats();
        return org.graylog.plugins.usagestatistics.dto.ClusterStats.create(this.elasticsearchCollector.getClusterStats(), this.elasticsearchCollector.getNodeInfos(), this.mongoCollector.getMongoStats(), this.collectorCollector.getCollectorInfos(), clusterStats.streamCount(), clusterStats.streamRuleCount(), clusterStats.streamRuleCountByStream(), clusterStats.userCount(), clusterStats.outputCount(), clusterStats.outputCountByType(), clusterStats.dashboardCount(), clusterStats.inputCount(), clusterStats.globalInputCount(), clusterStats.inputCountByType(), clusterStats.extractorCount(), this.buildExtractorCountByType(), clusterStats.contentPackCount(), this.counts.total(), this.buildStreamThroughput(), this.buildLdapStats(), this.buildAlarmStats());
    }

    private Map<String, Long> buildStreamThroughput() {
        return Collections.emptyMap();
    }

    private Map<String, Long> buildExtractorCountByType() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.clusterStatsService.clusterStats().extractorCountByType().entrySet()) {
            builder.put((Object)((Extractor.Type)entry.getKey()).name(), entry.getValue());
        }
        return builder.build();
    }

    private LdapStats buildLdapStats() {
        org.graylog2.system.stats.LdapStats ldapStats = this.clusterStatsService.ldapStats();
        return LdapStats.create(ldapStats.enabled(), ldapStats.activeDirectory(), ldapStats.roleMappingCount(), ldapStats.roleCount());
    }

    private org.graylog.plugins.usagestatistics.dto.AlarmStats buildAlarmStats() {
        AlarmStats stats = this.clusterStatsService.alarmStats();
        return org.graylog.plugins.usagestatistics.dto.AlarmStats.create(stats.alertCount(), stats.alarmcallbackCountByType());
    }
}

