/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.graylog.plugins.usagestatistics.dto.AutoValue_MacAddress;

@JsonAutoDetect
public abstract class MacAddress {
    public static final MacAddress EMPTY = new AutoValue_MacAddress("");
    private static final Pattern PATTERN = Pattern.compile("[0-9a-f]{2}([:-][0-9a-f]{2}){5}", 2);

    public static MacAddress create(String macAddress) {
        if (macAddress == null || macAddress.isEmpty()) {
            return EMPTY;
        }
        Preconditions.checkArgument((boolean)PATTERN.matcher(macAddress).matches());
        return new AutoValue_MacAddress(macAddress.substring(0, 8));
    }

    @JsonValue
    public abstract String macAddress();
}

