/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.graylog.plugins.usagestatistics.UsageStatsConfiguration;
import org.graylog.plugins.usagestatistics.UsageStatsConstants;
import org.graylog.plugins.usagestatistics.UsageStatsOptOutState;
import org.graylog.plugins.usagestatistics.UsageStatsRequest;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.periodical.Periodical;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;

public abstract class UsageStatsPeriodical
extends Periodical {
    protected final UsageStatsConfiguration config;
    protected final ClusterConfigService clusterConfigService;
    protected final EvictingQueue<UsageStatsRequest> cachedRequestsQueue;
    protected final ObjectMapper objectMapper;
    protected final OkHttpClient httpClient;
    protected final String filenamePattern;
    private final Logger log = this.getLogger();

    protected UsageStatsPeriodical(UsageStatsConfiguration config, ClusterConfigService clusterConfigService, EvictingQueue<UsageStatsRequest> usageStatsRequestsQueue, OkHttpClient httpClient, ObjectMapper objectMapper, String filenamePattern) {
        this.config = (UsageStatsConfiguration)Preconditions.checkNotNull((Object)config);
        this.clusterConfigService = (ClusterConfigService)Preconditions.checkNotNull((Object)clusterConfigService);
        this.cachedRequestsQueue = (EvictingQueue)Preconditions.checkNotNull(usageStatsRequestsQueue);
        this.httpClient = (OkHttpClient)Preconditions.checkNotNull((Object)httpClient);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
        this.filenamePattern = (String)Preconditions.checkNotNull((Object)filenamePattern);
    }

    protected abstract byte[] buildPayload();

    protected abstract URL getUrl();

    protected boolean isEnabled() {
        if (!this.config.isEnabled()) {
            return false;
        }
        UsageStatsOptOutState state = (UsageStatsOptOutState)this.clusterConfigService.getOrDefault(UsageStatsOptOutState.class, (Object)UsageStatsOptOutState.create(false));
        return !state.isOptOut();
    }

    public void doRun() {
        if (!this.isEnabled()) {
            this.log.debug("Anonymous usage statistics disabled: Not transmitting statistics");
            return;
        }
        this.log.debug("Anonymous usage statistics activated: Transmitting node statistics.");
        byte[] requestBody = this.buildPayload();
        if (this.config.isOfflineMode()) {
            boolean success;
            String filename = String.format(this.filenamePattern, DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
            if (!this.config.getDirectory().exists() && !(success = this.config.getDirectory().mkdirs())) {
                this.log.error("Couldn't create directory {}", (Object)this.config.getDirectory().getAbsolutePath());
                return;
            }
            File file = new File(this.config.getDirectory(), filename);
            this.log.debug("Anonymous usage statistics are in offline mode. Writing data into {}", (Object)file);
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                ((OutputStream)outputStream).write(requestBody);
            }
            catch (IOException e) {
                this.log.warn("Couldn't write usage statistics into " + file, (Throwable)e);
            }
        } else {
            Headers headers = new Headers.Builder().add("User-Agent", UsageStatsConstants.USER_AGENT).add("X-Usage-Statistics-Version", UsageStatsConstants.USAGE_STATS_VERSION).build();
            UsageStatsRequest request = UsageStatsRequest.create(headers, requestBody);
            boolean success = this.uploadDataSet(request);
            if (!success) {
                this.cachedRequestsQueue.add((Object)request);
            } else if (!this.cachedRequestsQueue.isEmpty()) {
                this.log.debug("Trying to upload {} queued data sets", (Object)this.cachedRequestsQueue.size());
                this.uploadQueuedDataSets();
            }
        }
    }

    protected void uploadQueuedDataSets() {
        ArrayList unsuccessfulRequests = Lists.newArrayListWithCapacity((int)this.cachedRequestsQueue.size());
        while (!this.cachedRequestsQueue.isEmpty()) {
            UsageStatsRequest request = (UsageStatsRequest)this.cachedRequestsQueue.poll();
            boolean success = this.uploadDataSet(request);
            if (success) continue;
            this.log.debug("Couldn't successfully upload anonymous usage statistics, re-queueing data");
            unsuccessfulRequests.add(request);
        }
        this.cachedRequestsQueue.addAll((Collection)unsuccessfulRequests);
    }

    protected boolean uploadDataSet(UsageStatsRequest usageStatsRequest) {
        Response response;
        URL url = this.getUrl();
        if (url == null) {
            this.log.warn("Error while uploading anonymous usage statistics. Please check the 'usage_statistics_url' setting in your configuration.");
            return false;
        }
        Request request = new Request.Builder().url(url).headers(usageStatsRequest.headers()).post(RequestBody.create((MediaType)UsageStatsConstants.CONTENT_TYPE, (byte[])usageStatsRequest.body())).build();
        try {
            response = this.httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            this.log.error("Error while uploading anonymous usage statistics");
            this.log.debug("Error details", (Throwable)e);
            return false;
        }
        if (!response.isSuccessful()) {
            this.log.warn("Couldn't successfully upload anonymous usage statistics: {}", (Object)response);
            return false;
        }
        return true;
    }

    public boolean runsForever() {
        return false;
    }

    public boolean stopOnGracefulShutdown() {
        return true;
    }

    public boolean masterOnly() {
        return false;
    }

    public boolean isDaemon() {
        return true;
    }

    public int getInitialDelaySeconds() {
        return Ints.saturatedCast((long)this.config.getInitialDelay().toSeconds());
    }

    public int getPeriodSeconds() {
        return Ints.saturatedCast((long)this.config.getReportInterval().toSeconds());
    }
}

