/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import org.graylog2.plugin.PluginConfigBean;

public class UsageStatsConfiguration
implements PluginConfigBean {
    private static final String PREFIX = "usage_statistics_";
    @Parameter(value="usage_statistics_enabled")
    private boolean enabled = true;
    @Parameter(value="usage_statistics_url", required=true)
    private URI url = URI.create("https://stats-collector.graylog.com/submit/");
    @Parameter(value="usage_statistics_cache_timeout", required=true, validator=PositiveDurationValidator.class)
    private Duration cacheTimeout = Duration.minutes((long)15L);
    @Parameter(value="usage_statistics_max_queue_size", required=true, validator=PositiveIntegerValidator.class)
    private int maxQueueSize = 10;
    @Parameter(value="usage_statistics_report_interval", required=true, validator=PositiveDurationValidator.class)
    private Duration reportInterval = Duration.hours((long)6L);
    @Parameter(value="usage_statistics_initial_delay", required=true, validator=PositiveDurationValidator.class)
    private Duration initialDelay = Duration.minutes((long)5L);
    @Parameter(value="usage_statistics_gzip_enabled")
    private boolean gzipEnabled = true;
    @Parameter(value="usage_statistics_offline_mode")
    private boolean offlineMode = false;
    @Parameter(value="usage_statistics_dir")
    private File directory = new File("data/usage-statistics");

    public boolean isEnabled() {
        return this.enabled;
    }

    public URI getUrl() {
        return this.url;
    }

    public Duration getCacheTimeout() {
        return this.cacheTimeout;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public Duration getReportInterval() {
        return this.reportInterval;
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public File getDirectory() {
        return this.directory;
    }

    @ValidatorMethod
    public void validate() throws ValidationException {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isOfflineMode() && Strings.isNullOrEmpty((String)this.getUrl().getHost())) {
            throw new ValidationException("Service URL " + this.getDirectory() + " must contain a hostname.");
        }
        if (this.isOfflineMode() && this.getDirectory().exists()) {
            if (!this.getDirectory().isDirectory()) {
                throw new ValidationException("Directory " + this.getDirectory() + " must be a directory.");
            }
            if (!this.getDirectory().canWrite()) {
                throw new ValidationException("Directory " + this.getDirectory() + " must be writable.");
            }
        }
    }
}

