/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.EvictingQueue;
import java.net.URI;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.graylog.plugins.usagestatistics.UsageStatsClusterService;
import org.graylog.plugins.usagestatistics.UsageStatsConfiguration;
import org.graylog.plugins.usagestatistics.UsageStatsPeriodical;
import org.graylog.plugins.usagestatistics.UsageStatsRequest;
import org.graylog.plugins.usagestatistics.providers.CompressingHttpClient;
import org.graylog.plugins.usagestatistics.providers.SmileObjectMapper;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UsageStatsClusterPeriodical
extends UsageStatsPeriodical {
    private static final Logger LOG = LoggerFactory.getLogger(UsageStatsClusterPeriodical.class);
    private final ServerStatus serverStatus;
    private final UsageStatsClusterService usageStatsClusterService;

    @Inject
    public UsageStatsClusterPeriodical(UsageStatsClusterService usageStatsClusterService, ServerStatus serverStatus, UsageStatsConfiguration config, ClusterConfigService clusterConfigService, @CompressingHttpClient OkHttpClient httpClient, @SmileObjectMapper ObjectMapper objectMapper) {
        this(usageStatsClusterService, serverStatus, config, clusterConfigService, (EvictingQueue<UsageStatsRequest>)EvictingQueue.create((int)config.getMaxQueueSize()), httpClient, objectMapper);
    }

    private UsageStatsClusterPeriodical(UsageStatsClusterService usageStatsClusterService, ServerStatus serverStatus, UsageStatsConfiguration config, ClusterConfigService clusterConfigService, EvictingQueue<UsageStatsRequest> evictingQueue, OkHttpClient httpClient, ObjectMapper objectMapper) {
        super(config, clusterConfigService, evictingQueue, httpClient, objectMapper, "cluster-%s.smile");
        this.serverStatus = serverStatus;
        this.usageStatsClusterService = usageStatsClusterService;
    }

    @Override
    protected URL getUrl() {
        ClusterId clusterId = (ClusterId)this.clusterConfigService.get(ClusterId.class);
        if (clusterId != null) {
            return HttpUrl.get((URI)this.config.getUrl()).newBuilder().addPathSegment("cluster").addPathSegment(clusterId.clusterId()).build().url();
        }
        return null;
    }

    @Override
    protected byte[] buildPayload() {
        try {
            return this.objectMapper.writeValueAsBytes((Object)this.usageStatsClusterService.buildClusterDataSet());
        }
        catch (JsonProcessingException e) {
            LOG.error("Error while serializing usage statistics data", (Throwable)e);
            return null;
        }
    }

    public boolean startOnThisNode() {
        return this.config.isEnabled() && this.serverStatus.hasCapability(ServerStatus.Capability.MASTER) && !this.serverStatus.hasCapability(ServerStatus.Capability.LOCALMODE);
    }

    protected Logger getLogger() {
        return LOG;
    }
}

