/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.usagestatistics.UsageStatsOptOutService;
import org.graylog.plugins.usagestatistics.UsageStatsOptOutState;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="UsageStatistics/Opt-Out", description="Anonymous usage statistics opt-out state of this Graylog setup")
@Path(value="/opt-out")
public class UsageStatsOptOutResource
extends RestResource
implements PluginRestResource {
    private static final String CLUSTER_CONFIG_INSTANCE = UsageStatsOptOutState.class.getCanonicalName();
    private final UsageStatsOptOutService usageStatsOptOutService;

    @Inject
    public UsageStatsOptOutResource(UsageStatsOptOutService usageStatsOptOutService) {
        this.usageStatsOptOutService = usageStatsOptOutService;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    @ApiOperation(value="Get opt-out status")
    @ApiResponses(value={@ApiResponse(code=404, message="Opt-out status does not exist"), @ApiResponse(code=500, message="Internal Server Error")})
    public UsageStatsOptOutState getOptOutState() {
        this.checkPermission("clusterconfigentry:read", CLUSTER_CONFIG_INSTANCE);
        UsageStatsOptOutState optOutState = this.usageStatsOptOutService.getOptOutState();
        if (optOutState == null) {
            throw new NotFoundException();
        }
        return optOutState;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    @ApiOperation(value="Disable sending anonymous usage stats")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid opt-out state"), @ApiResponse(code=500, message="Internal Server Error")})
    public void setOptOutState(@Valid @NotNull UsageStatsOptOutState optOutState) {
        this.checkPermission("clusterconfigentry:create", CLUSTER_CONFIG_INSTANCE);
        this.usageStatsOptOutService.setOptOutState(optOutState);
    }
}

