/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.usagestatistics.collectors;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.plugins.usagestatistics.dto.CollectorInfo;
import org.graylog2.collectors.Collector;
import org.graylog2.collectors.CollectorService;

public class CollectorCollector {
    private final CollectorService collectorService;

    @Inject
    public CollectorCollector(CollectorService collectorService) {
        this.collectorService = (CollectorService)Preconditions.checkNotNull((Object)collectorService);
    }

    public Set<CollectorInfo> getCollectorInfos() {
        ImmutableSet.Builder collectorInfos = ImmutableSet.builder();
        for (Collector collector : this.collectorService.all()) {
            collectorInfos.add((Object)CollectorInfo.create(collector.getCollectorVersion(), collector.getNodeDetails().operatingSystem()));
        }
        return collectorInfos.build();
    }
}

