/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids.forces.ntree;

import org.graphstream.boids.Boid;
import org.graphstream.boids.BoidForces;
import org.graphstream.boids.BoidForcesFactory;
import org.graphstream.boids.BoidGraph;
import org.graphstream.boids.forces.ntree.BoidCellData;
import org.graphstream.boids.forces.ntree.BoidParticle;
import org.graphstream.boids.forces.ntree.NTreeForces;
import org.graphstream.boids.forces.ntree.NTreeForces3D;
import org.graphstream.graph.Graph;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.GraphReplay;
import org.miv.pherd.Particle;
import org.miv.pherd.ParticleBox;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Anchor;
import org.miv.pherd.ntree.CellData;
import org.miv.pherd.ntree.CellSpace;
import org.miv.pherd.ntree.OctreeCellSpace;
import org.miv.pherd.ntree.QuadtreeCellSpace;

public class NTreeForcesFactory
implements BoidForcesFactory,
ElementSink {
    protected CellSpace space;
    protected ParticleBox pbox;
    protected BoidGraph ctx;
    protected boolean is3D;

    public NTreeForcesFactory(BoidGraph ctx) {
        this(ctx, false);
    }

    public NTreeForcesFactory(BoidGraph ctx, boolean is3D) {
        double area = ctx.getArea();
        int maxParticlesPerCell = 10;
        this.is3D = is3D;
        this.space = is3D ? new OctreeCellSpace(new Anchor(-area, -area, -area), new Anchor(area, area, area)) : new QuadtreeCellSpace(new Anchor(-area, -area, 0.0), new Anchor(area, area, 0.0));
        this.pbox = new ParticleBox(maxParticlesPerCell, this.space, (CellData)new BoidCellData());
        this.ctx = ctx;
    }

    @Override
    public void init() {
        GraphReplay replay = new GraphReplay("replay");
        replay.addElementSink((ElementSink)this);
        replay.replay((Graph)this.ctx);
        replay.removeElementSink((ElementSink)this);
        this.ctx.addElementSink(this);
    }

    @Override
    public BoidForces createNewForces(Boid b) {
        BoidParticle p = new BoidParticle(this.ctx, b);
        NTreeForces f = this.is3D ? new NTreeForces3D(p) : new NTreeForces(p);
        return f;
    }

    @Override
    public void step() {
        this.pbox.step();
    }

    @Override
    public void resize(Point3 low, Point3 high) {
        this.space.resize(low, high);
    }

    @Override
    public void end() {
        this.ctx.removeElementSink(this);
        this.pbox.removeAllParticles();
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
    }

    public void graphCleared(String sourceId, long timeId) {
        this.pbox.removeAllParticles();
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        Boid b = (Boid)this.ctx.getNode(nodeId);
        this.pbox.addParticle((Particle)((NTreeForces)b.getForces()).p);
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        Boid b = (Boid)this.ctx.getNode(nodeId);
        this.pbox.removeParticle(((NTreeForces)b.getForces()).p.getId());
    }

    public void stepBegins(String sourceId, long timeId, double step) {
    }
}

