/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids.forces.ntree;

import org.graphstream.boids.Boid;
import org.graphstream.boids.forces.ntree.BoidParticle;
import org.graphstream.boids.forces.ntree.NTreeForces;
import org.miv.pherd.ntree.Cell;

public class NTreeForces3D
extends NTreeForces {
    public NTreeForces3D(BoidParticle p) {
        super(p);
    }

    @Override
    protected boolean intersection(Boid source, Cell cell) {
        double vz = source.getSpecies().getViewZone();
        double x1 = cell.getSpace().getLoAnchor().x;
        double y1 = cell.getSpace().getLoAnchor().y;
        double z1 = cell.getSpace().getLoAnchor().z;
        double x2 = cell.getSpace().getHiAnchor().x;
        double y2 = cell.getSpace().getHiAnchor().y;
        double z2 = cell.getSpace().getHiAnchor().z;
        double X1 = source.getPosition().x - vz;
        double Y1 = source.getPosition().y - vz;
        double Z1 = source.getPosition().z - vz;
        double X2 = source.getPosition().x + vz;
        double Y2 = source.getPosition().y + vz;
        double Z2 = source.getPosition().z + vz;
        if (X2 < x1 || X1 > x2) {
            return false;
        }
        if (Y2 < y1 || Y1 > y2) {
            return false;
        }
        return !(Z2 < z1) && !(Z1 > z2);
    }

    @Override
    public boolean is3D() {
        return true;
    }
}

