/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids.forces.ntree;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.graphstream.boids.Boid;
import org.graphstream.boids.BoidForces;
import org.graphstream.boids.forces.ntree.BoidParticle;
import org.miv.pherd.Particle;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Cell;

public class NTreeForces
extends BoidForces {
    BoidParticle p;

    public NTreeForces(BoidParticle p) {
        super(p.b);
        this.p = p;
    }

    @Override
    public Point3 getPosition() {
        return this.p.getPosition();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.p.setPosition(x, y, z);
    }

    @Override
    public Point3 getNextPosition() {
        return this.p.getNextPosition();
    }

    protected void exploreTree(Cell cell, Set<Boid> contacts) {
        if (this.intersection(this.boid, cell)) {
            if (cell.isLeaf()) {
                this.forcesFromCell(cell, contacts);
            } else {
                int n = cell.getSpace().getDivisions();
                for (int i = 0; i < n; ++i) {
                    this.exploreTree(cell.getSub(i), contacts);
                }
            }
        }
    }

    protected void forcesFromCell(Cell cell, Set<Boid> contacts) {
        Iterator particles = cell.getParticles();
        while (particles.hasNext()) {
            Particle particle = (Particle)particles.next();
            if (!(particle instanceof BoidParticle) || this.p == particle || !this.isVisible(this.boid, particle.getPosition())) continue;
            contacts.add(((BoidParticle)particle).b);
        }
    }

    protected boolean intersection(Boid source, Cell cell) {
        double vz = source.getSpecies().getViewZone();
        double x1 = cell.getSpace().getLoAnchor().x;
        double y1 = cell.getSpace().getLoAnchor().y;
        double x2 = cell.getSpace().getHiAnchor().x;
        double y2 = cell.getSpace().getHiAnchor().y;
        double X1 = source.getPosition().x - vz;
        double Y1 = source.getPosition().y - vz;
        double X2 = source.getPosition().x + vz;
        double Y2 = source.getPosition().y + vz;
        if (X2 < x1 || X1 > x2) {
            return false;
        }
        return !(Y2 < y1) && !(Y1 > y2);
    }

    @Override
    public Collection<Boid> getNeighborhood() {
        HashSet<Boid> neigh = new HashSet<Boid>();
        Cell startCell = this.p.getCell().getTree().getRootCell();
        this.exploreTree(startCell, neigh);
        return neigh;
    }

    @Override
    public boolean is3D() {
        return false;
    }
}

