/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids.forces.greedy;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import org.graphstream.boids.Boid;
import org.graphstream.boids.BoidForces;
import org.graphstream.boids.BoidGraph;
import org.miv.pherd.geom.Point3;

public class GreedyForces
extends BoidForces {
    Point3 position;
    Point3 nextPosition;

    public GreedyForces(Boid b) {
        super(b);
        BoidGraph ctx = (BoidGraph)b.getGraph();
        Random r = ctx.getRandom();
        Point3 lo = ctx.getLowAnchor();
        Point3 hi = ctx.getHighAnchor();
        this.position = new Point3();
        this.nextPosition = new Point3();
        this.position.x = r.nextDouble() * (hi.x - lo.x) + lo.x;
        this.position.y = r.nextDouble() * (hi.y - lo.y) + lo.y;
        this.position.z = 0.0;
        this.nextPosition.copy(this.position);
    }

    @Override
    public Point3 getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
    }

    @Override
    public Collection<Boid> getNeighborhood() {
        BoidGraph g = (BoidGraph)this.boid.getGraph();
        LinkedList<Boid> contacts = new LinkedList<Boid>();
        for (Boid b : g.getEachNode()) {
            if (!this.isVisible(this.boid, b.getPosition())) continue;
            contacts.add(b);
        }
        return contacts;
    }

    @Override
    public Point3 getNextPosition() {
        return this.nextPosition;
    }

    @Override
    public boolean is3D() {
        return false;
    }
}

