/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids;

import java.util.HashMap;
import java.util.LinkedList;
import org.graphstream.boids.Boid;
import org.graphstream.boids.BoidGraph;
import org.graphstream.boids.BoidGraphListener;
import org.graphstream.boids.BoidSpecies;
import org.graphstream.boids.Probability;

public class DemographicManager
implements BoidGraphListener {
    protected BoidGraph ctx;
    protected int currentDate = 0;
    protected LinkedList<Boid> toRemove = new LinkedList();
    protected LinkedList<Boid> futureParents = new LinkedList();
    protected HashMap<Boid, Integer> birthdays = new HashMap();
    protected Probability reproduceProbability;
    protected Probability deathProbability;

    public DemographicManager(BoidGraph ctx) {
        this(ctx, new Probability.ConstantProbability(1.0), new Probability.DeathProbability());
    }

    public DemographicManager(BoidGraph ctx, Probability reproduceProbability, Probability deathProbability) {
        this.ctx = ctx;
        this.reproduceProbability = reproduceProbability;
        this.deathProbability = deathProbability;
        ctx.addBoidGraphListener(this);
    }

    public void setReproduceCondition(Probability rc) {
        this.reproduceProbability = rc;
    }

    public void setDeathProbability(Probability dp) {
        this.deathProbability = dp;
    }

    protected void register(Boid b) {
        this.birthdays.put(b, this.currentDate);
    }

    protected void unregister(Boid b) {
        this.birthdays.remove((Object)b);
    }

    protected void kill(Boid b) {
        this.unregister(b);
        this.ctx.removeNode(b.getId());
    }

    protected void killAll() {
        while (this.toRemove.size() > 0) {
            this.kill(this.toRemove.poll());
        }
    }

    protected void makeLove() {
        while (this.futureParents.size() > 0) {
            Boid b = this.futureParents.poll();
            String id = b.getSpecies().createNewId();
            this.ctx.addNode(id);
        }
    }

    protected void check() {
        for (Boid b : this.birthdays.keySet()) {
            int age = this.currentDate - this.birthdays.get((Object)b);
            if ((double)this.ctx.random.nextFloat() < this.deathProbability.getProbability(this.ctx, b, age)) {
                this.toRemove.add(b);
                continue;
            }
            if (!((double)this.ctx.random.nextFloat() < this.reproduceProbability.getProbability(this.ctx, b, age))) continue;
            this.futureParents.add(b);
        }
        this.makeLove();
        this.killAll();
        ++this.currentDate;
    }

    @Override
    public void boidAdded(Boid boid) {
        this.register(boid);
    }

    @Override
    public void boidDeleted(Boid boid) {
        this.unregister(boid);
    }

    @Override
    public void step(double time) {
        this.check();
    }

    public void release() {
        this.ctx.removeBoidGraphListener(this);
    }

    public static class SpeciesDemographicManager
    extends DemographicManager {
        BoidSpecies species;

        public SpeciesDemographicManager(BoidSpecies species, BoidGraph ctx) {
            super(ctx);
            this.species = species;
        }

        public SpeciesDemographicManager(BoidSpecies species, BoidGraph ctx, Probability r, Probability d) {
            super(ctx, r, d);
            this.species = species;
        }

        @Override
        protected void register(Boid b) {
            if (b.getSpecies() == this.species) {
                super.register(b);
            }
        }

        @Override
        protected void unregister(Boid b) {
            if (b.getSpecies() == this.species) {
                super.unregister(b);
            }
        }
    }
}

