/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids;

import org.graphstream.algorithm.generator.Generator;
import org.graphstream.boids.BoidGraph;
import org.graphstream.boids.BoidSpecies;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SourceBase;

public class BoidGenerator
extends SourceBase
implements Generator {
    protected BoidGraph ctx;
    protected String configuration;
    private Link proxy;

    public BoidGenerator() {
        this(null);
    }

    public BoidGenerator(String dgsConfiguration) {
        this.configuration = dgsConfiguration;
        this.ctx = null;
        this.proxy = new Link();
    }

    public BoidGraph getBoidGraph() {
        return this.ctx;
    }

    public void begin() {
        if (this.ctx != null) {
            throw new RuntimeException("generation already started");
        }
        this.ctx = new BoidGraph();
        this.ctx.addSink(this.proxy);
        if (this.configuration != null) {
            try {
                this.ctx.loadDGSConfiguration(this.configuration);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            BoidSpecies species = this.ctx.addDefaultSpecies();
            species.setInitialCount(100);
            species.populate();
        }
    }

    public void end() {
        this.ctx.clearSinks();
        this.ctx.clear();
        this.ctx = null;
    }

    public boolean nextEvents() {
        this.ctx.step();
        return true;
    }

    private class Link
    implements Sink {
        private Link() {
        }

        public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
            BoidGenerator.this.sendEdgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
        }

        public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
            BoidGenerator.this.sendEdgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
        }

        public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
            BoidGenerator.this.sendEdgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
        }

        public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
            BoidGenerator.this.sendGraphAttributeAdded(sourceId, timeId, attribute, value);
        }

        public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
            BoidGenerator.this.sendGraphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
        }

        public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
            BoidGenerator.this.sendGraphAttributeRemoved(sourceId, timeId, attribute);
        }

        public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
            BoidGenerator.this.sendNodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
        }

        public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
            BoidGenerator.this.sendNodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
        }

        public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
            BoidGenerator.this.sendNodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
        }

        public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
            BoidGenerator.this.sendEdgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
        }

        public void edgeRemoved(String sourceId, long timeId, String edgeId) {
            BoidGenerator.this.sendEdgeRemoved(sourceId, timeId, edgeId);
        }

        public void graphCleared(String sourceId, long timeId) {
            BoidGenerator.this.sendGraphCleared(sourceId, timeId);
        }

        public void nodeAdded(String sourceId, long timeId, String nodeId) {
            BoidGenerator.this.sendNodeAdded(sourceId, timeId, nodeId);
        }

        public void nodeRemoved(String sourceId, long timeId, String nodeId) {
            BoidGenerator.this.sendNodeRemoved(sourceId, timeId, nodeId);
        }

        public void stepBegins(String sourceId, long timeId, double step) {
            BoidGenerator.this.sendStepBegins(sourceId, timeId, step);
        }
    }
}

