/*
 * Copyright 2006 - 2012
 *     Antoine Dutot	<antoine.dutot@graphstream-project.org>
 *     Guilhelm Savin	<guilhelm.savin@graphstream-project.org>
 * 
 * This file is part of gs-boids <http://graphstream-project.org>.
 * 
 * gs-boids is a library whose purpose is to provide a boid behavior to a set of
 * particles.
 * 
 * This program is free software distributed under the terms of two licenses, the
 * CeCILL-C license that fits European law, and the GNU Lesser General Public
 * License. You can  use, modify and/ or redistribute the software under the terms
 * of the CeCILL-C license as circulated by CEA, CNRS and INRIA at the following
 * URL <http://www.cecill.info> or under the terms of the GNU LGPL as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C and LGPL licenses and that you accept their terms.
 */
package org.graphstream.boids;

import org.miv.pherd.geom.Point3;

/**
 * Object used to create and compute forces of boids.
 * 
 */
public interface BoidForcesFactory {
	/**
	 * Called by {@link org.graphstream.boids.BoidGraph} when forces factory is
	 * set. It allows the forces factory to execute some code before it starts.
	 */
	void init();

	/**
	 * Create a new forces object for a boid.
	 * 
	 * @param b
	 *            the boid
	 * @return a new forces object associate with the boid
	 */
	BoidForces createNewForces(Boid b);

	/**
	 * Compute forces for all boids.
	 */
	void step();

	/**
	 * Resize the space.
	 * 
	 * @param low the new lowest point.
	 * @param high the new highest point.
	 */
	void resize(Point3 low, Point3 high);

	/**
	 * Terminate all operations.
	 */
	void end();
}
