/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.boids.forces.ntree;

import java.util.Iterator;
import org.graphstream.boids.forces.ntree.BoidParticle;
import org.miv.pherd.Particle;
import org.miv.pherd.geom.Vector3;
import org.miv.pherd.ntree.BarycenterCellData;
import org.miv.pherd.ntree.Cell;
import org.miv.pherd.ntree.CellData;
import org.miv.pherd.ntree.NTreeListener;

public class BoidCellData
extends BarycenterCellData {
    public Vector3 dir = new Vector3(0.0, 0.0, 0.0);

    public Vector3 getDirection() {
        return this.dir;
    }

    public CellData newCellData() {
        return new BoidCellData();
    }

    public void recompute() {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float n = 0.0f;
        this.dir.fill(0.0);
        this.weight = this.cell.getPopulation();
        if (this.cell.isLeaf()) {
            Iterator particles = this.cell.getParticles();
            while (particles.hasNext()) {
                Particle p = (Particle)particles.next();
                if (!(p instanceof BoidParticle)) continue;
                BoidParticle particle = (BoidParticle)p;
                x = (float)((double)x + particle.getPosition().x);
                y = (float)((double)y + particle.getPosition().y);
                z = (float)((double)z + particle.getPosition().z);
                this.dir.add(particle.b.getForces().getDirection());
                n += 1.0f;
            }
            if (n > 0.0f) {
                x /= n;
                y /= n;
                z /= n;
            }
            this.center.set((double)x, (double)y, (double)z);
            if (n > 0.0f) {
                this.dir.scalarDiv((double)n);
            }
        } else {
            float subcnt = this.cell.getSpace().getDivisions();
            float totpop = this.cell.getPopulation();
            int verif = 0;
            if (totpop > 0.0f) {
                int i = 0;
                while ((float)i < subcnt) {
                    Cell subcell = this.cell.getSub(i);
                    BoidCellData data = (BoidCellData)subcell.getData();
                    float pop = subcell.getPopulation();
                    verif = (int)((float)verif + pop);
                    x = (float)((double)x + data.center.x * (double)pop);
                    y = (float)((double)y + data.center.y * (double)pop);
                    z = (float)((double)z + data.center.z * (double)pop);
                    this.dir.add(data.dir);
                    ++i;
                }
                assert ((float)verif == totpop) : "Discrepancy in population counts ?";
                x /= totpop;
                y /= totpop;
                z /= totpop;
            }
            this.center.set((double)x, (double)y, (double)z);
            if (totpop > 0.0f) {
                this.dir.scalarDiv((double)totpop);
            }
        }
        for (NTreeListener listener : this.cell.getTree().getListeners()) {
            listener.cellData((Object)this.cell.getId(), "barycenter", (Object)this);
        }
    }
}

